/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterNetwork;
import org.ovirt.engine.sdk.decorators.DataCenterNetworkVnicProfile;
import org.ovirt.engine.sdk.entities.VnicProfile;
import org.ovirt.engine.sdk.entities.VnicProfiles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterNetworkVnicProfiles
extends CollectionDecorator<VnicProfile, VnicProfiles, DataCenterNetworkVnicProfile> {
    private DataCenterNetwork parent;

    public DataCenterNetworkVnicProfiles(HttpProxyBroker proxy, DataCenterNetwork parent) {
        super(proxy, "vnicprofiles");
        this.parent = parent;
    }

    @Override
    public List<DataCenterNetworkVnicProfile> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, VnicProfiles.class, DataCenterNetworkVnicProfile.class);
    }

    @Override
    public DataCenterNetworkVnicProfile get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, VnicProfile.class, DataCenterNetworkVnicProfile.class);
    }

    @Override
    public DataCenterNetworkVnicProfile getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, VnicProfile.class, DataCenterNetworkVnicProfile.class);
    }

    public DataCenterNetworkVnicProfile add(VnicProfile vnicprofile) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vnicprofile, VnicProfile.class, DataCenterNetworkVnicProfile.class, headers);
    }
}

