/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.SchedulingPolicy;
import org.ovirt.engine.sdk.decorators.SchedulingPolicyFilter;
import org.ovirt.engine.sdk.entities.Filter;
import org.ovirt.engine.sdk.entities.Filters;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class SchedulingPolicyFilters
extends CollectionDecorator<Filter, Filters, SchedulingPolicyFilter> {
    private SchedulingPolicy parent;

    public SchedulingPolicyFilters(HttpProxyBroker proxy, SchedulingPolicy parent) {
        super(proxy, "filters");
        this.parent = parent;
    }

    @Override
    public List<SchedulingPolicyFilter> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Filters.class, SchedulingPolicyFilter.class);
    }

    @Override
    public SchedulingPolicyFilter get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Filter.class, SchedulingPolicyFilter.class);
    }

    @Override
    public SchedulingPolicyFilter getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Filter.class, SchedulingPolicyFilter.class);
    }

    public SchedulingPolicyFilter add(Filter filter) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, filter, Filter.class, SchedulingPolicyFilter.class, headers);
    }
}

