/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterCluster;
import org.ovirt.engine.sdk.decorators.DataCenterClusterCpuProfile;
import org.ovirt.engine.sdk.entities.CpuProfile;
import org.ovirt.engine.sdk.entities.CpuProfiles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterClusterCpuProfiles
extends CollectionDecorator<CpuProfile, CpuProfiles, DataCenterClusterCpuProfile> {
    private DataCenterCluster parent;

    public DataCenterClusterCpuProfiles(HttpProxyBroker proxy, DataCenterCluster parent) {
        super(proxy, "cpuprofiles");
        this.parent = parent;
    }

    @Override
    public List<DataCenterClusterCpuProfile> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, CpuProfiles.class, DataCenterClusterCpuProfile.class);
    }

    @Override
    public DataCenterClusterCpuProfile get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, CpuProfile.class, DataCenterClusterCpuProfile.class);
    }

    @Override
    public DataCenterClusterCpuProfile getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, CpuProfile.class, DataCenterClusterCpuProfile.class);
    }

    public DataCenterClusterCpuProfile add(CpuProfile cpuprofile) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, cpuprofile, CpuProfile.class, DataCenterClusterCpuProfile.class, headers);
    }
}

