/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.SchedulingPolicy;
import org.ovirt.engine.sdk.decorators.SchedulingPolicyWeight;
import org.ovirt.engine.sdk.entities.Weight;
import org.ovirt.engine.sdk.entities.Weights;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class SchedulingPolicyWeights
extends CollectionDecorator<Weight, Weights, SchedulingPolicyWeight> {
    private SchedulingPolicy parent;

    public SchedulingPolicyWeights(HttpProxyBroker proxy, SchedulingPolicy parent) {
        super(proxy, "weights");
        this.parent = parent;
    }

    @Override
    public List<SchedulingPolicyWeight> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Weights.class, SchedulingPolicyWeight.class);
    }

    @Override
    public SchedulingPolicyWeight get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Weight.class, SchedulingPolicyWeight.class);
    }

    @Override
    public SchedulingPolicyWeight getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Weight.class, SchedulingPolicyWeight.class);
    }

    public SchedulingPolicyWeight add(Weight weight) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, weight, Weight.class, SchedulingPolicyWeight.class, headers);
    }
}

