/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.InstanceType;
import org.ovirt.engine.sdk.decorators.InstanceTypeNIC;
import org.ovirt.engine.sdk.entities.NIC;
import org.ovirt.engine.sdk.entities.Nics;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class InstanceTypeNICs
extends CollectionDecorator<NIC, Nics, InstanceTypeNIC> {
    private InstanceType parent;

    public InstanceTypeNICs(HttpProxyBroker proxy, InstanceType parent) {
        super(proxy, "nics");
        this.parent = parent;
    }

    @Override
    public List<InstanceTypeNIC> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Nics.class, InstanceTypeNIC.class);
    }

    @Override
    public InstanceTypeNIC get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, NIC.class, InstanceTypeNIC.class);
    }

    @Override
    public InstanceTypeNIC getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, NIC.class, InstanceTypeNIC.class);
    }

    public InstanceTypeNIC add(NIC nic) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, nic, NIC.class, InstanceTypeNIC.class, headers);
    }
}

