/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Cluster;
import org.ovirt.engine.sdk.decorators.ClusterCpuProfile;
import org.ovirt.engine.sdk.entities.CpuProfile;
import org.ovirt.engine.sdk.entities.CpuProfiles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class ClusterCpuProfiles
extends CollectionDecorator<CpuProfile, CpuProfiles, ClusterCpuProfile> {
    private Cluster parent;

    public ClusterCpuProfiles(HttpProxyBroker proxy, Cluster parent) {
        super(proxy, "cpuprofiles");
        this.parent = parent;
    }

    @Override
    public List<ClusterCpuProfile> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, CpuProfiles.class, ClusterCpuProfile.class);
    }

    @Override
    public ClusterCpuProfile get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, CpuProfile.class, ClusterCpuProfile.class);
    }

    @Override
    public ClusterCpuProfile getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, CpuProfile.class, ClusterCpuProfile.class);
    }

    public List<ClusterCpuProfile> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, CpuProfiles.class, ClusterCpuProfile.class, headers);
    }

    public ClusterCpuProfile add(CpuProfile cpuprofile) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, cpuprofile, CpuProfile.class, ClusterCpuProfile.class, headers);
    }

    public ClusterCpuProfile add(CpuProfile cpuprofile, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, cpuprofile, CpuProfile.class, ClusterCpuProfile.class, headers);
    }

    public ClusterCpuProfile add(CpuProfile cpuprofile, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, cpuprofile, CpuProfile.class, ClusterCpuProfile.class, headers);
    }
}

