/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.SchedulingPolicy;
import org.ovirt.engine.sdk.decorators.SchedulingPolicyBalance;
import org.ovirt.engine.sdk.entities.Balance;
import org.ovirt.engine.sdk.entities.Balances;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class SchedulingPolicyBalances
extends CollectionDecorator<Balance, Balances, SchedulingPolicyBalance> {
    private SchedulingPolicy parent;

    public SchedulingPolicyBalances(HttpProxyBroker proxy, SchedulingPolicy parent) {
        super(proxy, "balances");
        this.parent = parent;
    }

    @Override
    public List<SchedulingPolicyBalance> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Balances.class, SchedulingPolicyBalance.class);
    }

    @Override
    public SchedulingPolicyBalance get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Balance.class, SchedulingPolicyBalance.class);
    }

    @Override
    public SchedulingPolicyBalance getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Balance.class, SchedulingPolicyBalance.class);
    }

    public SchedulingPolicyBalance add(Balance balance) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, balance, Balance.class, SchedulingPolicyBalance.class, headers);
    }
}

