/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.StorageDomain;
import org.ovirt.engine.sdk.decorators.StorageDomainDisk;
import org.ovirt.engine.sdk.entities.Disk;
import org.ovirt.engine.sdk.entities.Disks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class StorageDomainDisks
extends CollectionDecorator<Disk, Disks, StorageDomainDisk> {
    private StorageDomain parent;

    public StorageDomainDisks(HttpProxyBroker proxy, StorageDomain parent) {
        super(proxy, "disks");
        this.parent = parent;
    }

    @Override
    public List<StorageDomainDisk> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Disks.class, StorageDomainDisk.class);
    }

    @Override
    public StorageDomainDisk get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Disk.class, StorageDomainDisk.class);
    }

    @Override
    public StorageDomainDisk getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Disk.class, StorageDomainDisk.class);
    }

    public List<StorageDomainDisk> list(String query, Boolean caseSensitive, Integer max, Boolean unregistered) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        if (unregistered != null) {
            urlBuilder.add("unregistered", unregistered, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, Disks.class, StorageDomainDisk.class, headers);
    }

    public StorageDomainDisk add(Disk disk) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, disk, Disk.class, StorageDomainDisk.class, headers);
    }

    public StorageDomainDisk add(Disk disk, Boolean unregistered) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (unregistered != null) {
            urlBuilder.add("unregistered", unregistered, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().add(url, disk, Disk.class, StorageDomainDisk.class, headers);
    }

    public StorageDomainDisk add(Disk disk, Boolean unregistered, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (unregistered != null) {
            urlBuilder.add("unregistered", unregistered, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().add(url, disk, Disk.class, StorageDomainDisk.class, headers);
    }

    public StorageDomainDisk add(Disk disk, Boolean unregistered, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (unregistered != null) {
            urlBuilder.add("unregistered", unregistered, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().add(url, disk, Disk.class, StorageDomainDisk.class, headers);
    }
}

