/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterCluster;
import org.ovirt.engine.sdk.decorators.DataCenterClusterAffinityGroup;
import org.ovirt.engine.sdk.entities.AffinityGroup;
import org.ovirt.engine.sdk.entities.AffinityGroups;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterClusterAffinityGroups
extends CollectionDecorator<AffinityGroup, AffinityGroups, DataCenterClusterAffinityGroup> {
    private DataCenterCluster parent;

    public DataCenterClusterAffinityGroups(HttpProxyBroker proxy, DataCenterCluster parent) {
        super(proxy, "affinitygroups");
        this.parent = parent;
    }

    @Override
    public List<DataCenterClusterAffinityGroup> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, AffinityGroups.class, DataCenterClusterAffinityGroup.class);
    }

    @Override
    public DataCenterClusterAffinityGroup get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, AffinityGroup.class, DataCenterClusterAffinityGroup.class);
    }

    @Override
    public DataCenterClusterAffinityGroup getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, AffinityGroup.class, DataCenterClusterAffinityGroup.class);
    }

    public DataCenterClusterAffinityGroup add(AffinityGroup affinitygroup) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, affinitygroup, AffinityGroup.class, DataCenterClusterAffinityGroup.class, headers);
    }
}

