/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Cluster;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Clusters
extends CollectionDecorator<org.ovirt.engine.sdk.entities.Cluster, org.ovirt.engine.sdk.entities.Clusters, Cluster> {
    public Clusters(HttpProxyBroker proxy) {
        super(proxy, "clusters");
    }

    @Override
    public List<Cluster> list() throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        return this.list(url, org.ovirt.engine.sdk.entities.Clusters.class, Cluster.class);
    }

    @Override
    public Cluster get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class);
    }

    @Override
    public Cluster getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class);
    }

    public Cluster add(org.ovirt.engine.sdk.entities.Cluster cluster) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, cluster, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class, headers);
    }

    public Cluster add(org.ovirt.engine.sdk.entities.Cluster cluster, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, cluster, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class, headers);
    }

    public Cluster add(org.ovirt.engine.sdk.entities.Cluster cluster, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, cluster, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class, headers);
    }

    public List<Cluster> list(String query) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Clusters.class, Cluster.class, headers);
    }

    public List<Cluster> list(String query, Boolean caseSensitive) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Clusters.class, Cluster.class, headers);
    }

    public List<Cluster> list(String query, Boolean caseSensitive, Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Clusters.class, Cluster.class, headers);
    }
}

