/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.UserPermissions;
import org.ovirt.engine.sdk.decorators.UserRoles;
import org.ovirt.engine.sdk.decorators.UserTags;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class User
extends org.ovirt.engine.sdk.entities.User {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile UserPermissions userPermissions;
    private volatile UserRoles userRoles;
    private volatile UserTags userTags;

    public User(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserPermissions getPermissions() {
        if (this.userPermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.userPermissions == null) {
                    this.userPermissions = new UserPermissions(this.proxy, this);
                }
            }
        }
        return this.userPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserRoles getRoles() {
        if (this.userRoles == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.userRoles == null) {
                    this.userRoles = new UserRoles(this.proxy, this);
                }
            }
        }
        return this.userRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTags getTags() {
        if (this.userTags == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.userTags == null) {
                    this.userTags = new UserTags(this.proxy, this);
                }
            }
        }
        return this.userTags;
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

