/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.signature;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.signature.TypeParameter;
import org.objectweb.asm.tree.signature.TypeSignature;
import org.objectweb.asm.tree.signature.TypeSignatureFactory;

public class ClassSignature
extends SignatureVisitor {
    public List<TypeParameter> typeParameters;
    public TypeSignature superClass;
    public List<TypeSignature> interfaces;

    public ClassSignature(int api) {
        super(api);
    }

    public void visitFormalTypeParameter(String name) {
        if (this.typeParameters == null) {
            this.typeParameters = new ArrayList<TypeParameter>();
        }
        TypeParameter typeParameter = new TypeParameter(this.api);
        typeParameter.visitFormalTypeParameter(name);
        this.typeParameters.add(typeParameter);
    }

    public SignatureVisitor visitClassBound() {
        int currentParameterIndex = this.typeParameters.size() - 1;
        return this.typeParameters.get(currentParameterIndex).visitClassBound();
    }

    public SignatureVisitor visitInterfaceBound() {
        int currentParameterIndex = this.typeParameters.size() - 1;
        return this.typeParameters.get(currentParameterIndex).visitInterfaceBound();
    }

    public SignatureVisitor visitSuperclass() {
        return new TypeSignatureFactory(this.api, this);
    }

    public SignatureVisitor visitInterface() {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<TypeSignature>();
        }
        return new TypeSignatureFactory(this.api, this.interfaces);
    }

    public void accept(SignatureVisitor sv) {
        if (this.typeParameters != null) {
            for (TypeParameter p : this.typeParameters) {
                p.accept(sv);
            }
        }
        if (this.superClass != null) {
            this.superClass.accept(sv.visitSuperclass());
        }
        if (this.interfaces != null) {
            for (TypeSignature s : this.interfaces) {
                s.accept(sv.visitInterface());
            }
        }
    }
}

