/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.signature;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.signature.TypeArgument;
import org.objectweb.asm.tree.signature.TypeSignature;

public class ClassType
extends TypeSignature {
    public String name;
    public List<TypeArgument> arguments;
    public ClassType innerClass;

    public ClassType(int api) {
        super(api);
    }

    public void visitClassType(String name) {
        this.name = name;
    }

    public void visitInnerClassType(String name) {
        ClassType current = this.getCurrentClassType();
        current.innerClass = new ClassType(this.api);
        current.innerClass.name = name;
    }

    public void visitTypeArgument() {
        ClassType current = this.getCurrentClassType();
        if (current.arguments == null) {
            current.arguments = new ArrayList<TypeArgument>();
        }
        TypeArgument typeArgument = new TypeArgument(this.api);
        current.arguments.add(typeArgument);
        typeArgument.visitTypeArgument();
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        ClassType current = this.getCurrentClassType();
        if (current.arguments == null) {
            current.arguments = new ArrayList<TypeArgument>();
        }
        TypeArgument typeArgument = new TypeArgument(this.api);
        current.arguments.add(typeArgument);
        return typeArgument.visitTypeArgument(wildcard);
    }

    public void accept(SignatureVisitor sv) {
        sv.visitClassType(this.name);
        if (this.arguments != null) {
            for (TypeArgument a : this.arguments) {
                a.accept(sv);
            }
        }
        ClassType inner = this.innerClass;
        while (inner != null) {
            sv.visitInnerClassType(inner.name);
            if (inner.arguments != null) {
                for (TypeArgument a : inner.arguments) {
                    a.accept(sv);
                }
            }
            inner = inner.innerClass;
        }
        sv.visitEnd();
    }

    private ClassType getCurrentClassType() {
        ClassType currentClass = this;
        while (currentClass.innerClass != null) {
            currentClass = currentClass.innerClass;
        }
        return currentClass;
    }
}

