/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.signature;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.signature.TypeParameter;
import org.objectweb.asm.tree.signature.TypeSignature;
import org.objectweb.asm.tree.signature.TypeSignatureFactory;

public class MethodSignature
extends SignatureVisitor {
    public List<TypeParameter> typeParameters;
    public TypeSignature receiver;
    public List<TypeSignature> parameters;
    public TypeSignature result;
    public List<TypeSignature> exceptions;

    public MethodSignature(int api) {
        super(api);
    }

    public void visitFormalTypeParameter(String name) {
        if (this.typeParameters == null) {
            this.typeParameters = new ArrayList<TypeParameter>();
        }
        TypeParameter typeParameter = new TypeParameter(this.api);
        typeParameter.visitFormalTypeParameter(name);
        this.typeParameters.add(typeParameter);
    }

    public SignatureVisitor visitClassBound() {
        int currentParameterIndex = this.typeParameters.size() - 1;
        return this.typeParameters.get(currentParameterIndex).visitClassBound();
    }

    public SignatureVisitor visitInterfaceBound() {
        int currentParameterIndex = this.typeParameters.size() - 1;
        return this.typeParameters.get(currentParameterIndex).visitInterfaceBound();
    }

    public SignatureVisitor visitParameterType() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<TypeSignature>();
        }
        return new TypeSignatureFactory(this.api, this.parameters);
    }

    public SignatureVisitor visitReturnType() {
        return new TypeSignatureFactory(this.api, this);
    }

    public SignatureVisitor visitExceptionType() {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<TypeSignature>();
        }
        return new TypeSignatureFactory(this.api, this.exceptions);
    }

    public void accept(SignatureVisitor sv) {
        if (this.typeParameters != null) {
            for (TypeParameter p : this.typeParameters) {
                p.accept(sv);
            }
        }
        if (this.parameters != null) {
            for (TypeSignature s : this.parameters) {
                s.accept(sv.visitParameterType());
            }
        }
        if (this.result != null) {
            this.result.accept(sv.visitReturnType());
        } else {
            sv.visitReturnType().visitBaseType('V');
        }
        if (this.exceptions != null) {
            for (TypeSignature s : this.exceptions) {
                s.accept(sv.visitExceptionType());
            }
        }
    }
}

