/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.audit.jmx;

import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.ow2.easybeans.component.audit.jmx.JMXNotifierMBean;
import org.ow2.easybeans.jmx.JMXRemoteException;
import org.ow2.easybeans.jmx.MBeanServerHelper;
import org.ow2.easybeans.jmx.MBeansException;
import org.ow2.easybeans.jmx.MBeansHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JMXNotifier
extends NotificationBroadcasterSupport
implements JMXNotifierMBean {
    private static final String NOTIFIER_NAME = ":type=Auditors,auditorType=ejb,name=EasyBeans";
    private static Log logger = LogFactory.getLog(JMXNotifier.class);
    private static final int ZERO = 0;
    private ObjectName notifier = null;
    private long seqNumber = 0L;
    private MBeanServer server = null;

    private MBeanServer getMBeanServer() {
        try {
            return MBeanServerHelper.getMBeanServerServer();
        }
        catch (JMXRemoteException e) {
            throw new IllegalStateException("Cannot get an MBean server", e);
        }
    }

    public JMXNotifier() {
        try {
            this.notifier = new ObjectName(MBeansHelper.getDomainName() + NOTIFIER_NAME);
            this.server = this.getMBeanServer();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while registering Easybeans Audit notifier : ", new Object[]{ex});
        }
        this.registration();
    }

    private long getNextSeqNumber() {
        return this.seqNumber++;
    }

    public void registration() {
        if (this.server != null) {
            try {
                if (!this.server.isRegistered(this.notifier)) {
                    this.server.registerMBean(this, this.notifier);
                }
            }
            catch (Exception e) {
                logger.error((Object)e, new Object[0]);
            }
        } else {
            logger.error((Object)"MBeanServer not found and could not be created. Not registering MBeans.", new Object[0]);
        }
    }

    public void unregistration() {
        try {
            MBeansHelper.getInstance().unregisterMBean((Object)this);
        }
        catch (MBeansException ex) {
            logger.error((Object)"Error while registering Easybeans Audit notifier : ", new Object[]{ex});
        }
    }

    public synchronized void sendAuditNotification(String type, String report) {
        if (report != null) {
            this.sendNotification(new Notification(type, (Object)this, this.getNextSeqNumber(), report));
        }
    }
}

