/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.cmi;

import java.util.Set;
import org.ow2.cmi.annotation.Cluster;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.binding.EZBRef;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.api.event.bean.EZBClusteredBeanEvent;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;
import org.ow2.easybeans.proxy.reference.RemoteCallRef;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CmiEventListener
implements EZBEventListener {
    public static final String NAMING_EXTENSION_POINT = "/easybeans/container/factory/context";
    private static Log logger = LogFactory.getLog(CmiEventListener.class);

    public String getEventProviderFilter() {
        return NAMING_EXTENSION_POINT;
    }

    public boolean accept(IEvent arg0) {
        return arg0 instanceof EZBClusteredBeanEvent;
    }

    public EventPriority getPriority() {
        return EventPriority.SYNC_LOW;
    }

    public void handle(IEvent arg0) {
        EZBClusteredBeanEvent clusterEvent = (EZBClusteredBeanEvent)arg0;
        if ("STARTING".equals(clusterEvent.getState()) || "STOPPING".equals(clusterEvent.getState())) {
            for (EZBRef reference : clusterEvent.getReferences()) {
                Factory factory;
                if (!(reference instanceof RemoteCallRef) || !((factory = reference.getFactory()) instanceof SessionFactory)) continue;
                SessionFactory fact = (SessionFactory)factory;
                Object cluster = fact.getBeanInfo().getCluster();
                Class beanClass = fact.getBeanClass();
                Class<?> itfClass = null;
                if (cluster == null && !beanClass.isAnnotationPresent(Cluster.class)) continue;
                if ("STARTING".equals(clusterEvent.getState())) {
                    String itfClassname = reference.getItfClassName();
                    logger.info((Object)"The bean with the jndi name {0} and the interface name {1} is clustered.", new Object[]{reference.getJNDIName(), itfClassname});
                    for (Class<?> klass : beanClass.getInterfaces()) {
                        if (!klass.getName().equals(itfClassname)) continue;
                        itfClass = klass;
                    }
                    if (itfClass == null) {
                        logger.error((Object)"Cannot find the interface for name {0}", new Object[]{itfClassname});
                    }
                    Set applicationExceptionNames = factory.getBeanInfo().getApplicationExceptions().keySet();
                    ClusteredObjectInfo infos = null;
                    try {
                        infos = cluster != null ? CMIInfoExtractor.extractClusteringInfoFromClusteredObject((Object)cluster, itfClass, (Class)beanClass, (boolean)(factory instanceof StatefulSessionFactory), (boolean)false, applicationExceptionNames) : CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO((String)reference.getJNDIName(), itfClass, (Class)beanClass, (boolean)(factory instanceof StatefulSessionFactory), applicationExceptionNames);
                        CMIInfoRepository.addClusteredObjectInfo((String)reference.getJNDIName(), (ClusteredObjectInfo)infos);
                    }
                    catch (CMIInfoExtractorException e) {
                        logger.error((Object)"Cannot extract infos for the class with name {0}", new Object[]{beanClass.getName(), e});
                    }
                    continue;
                }
                CMIInfoRepository.removeClusteredObjectInfo((String)reference.getJNDIName());
            }
        }
    }
}

