/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jdbcpool;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.ow2.easybeans.component.jdbcpool.DataSourceFactory;
import org.ow2.easybeans.component.jdbcpool.IConnection;
import org.ow2.easybeans.component.jdbcpool.IManagedConnection;
import org.ow2.easybeans.component.jdbcpool.JManagedConnection;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManager
implements DataSource,
XADataSource,
Referenceable,
ConnectionEventListener {
    private Log logger = LogFactory.getLog(ConnectionManager.class);
    private static final long MILLI = 1000L;
    private static final long ONE_MIN_MILLI = 60000L;
    private static final int DEFAULT_TIMEOUT = 60;
    private static final long WAITER_TIMEOUT = 10000L;
    private static final int DEFAULT_MAX_WAITERS = 1000;
    private static final int DEFAULT_PSTMT = 12;
    private static final int DEFAULT_SAMPLING = 60;
    private static Map<String, ConnectionManager> cmList = new HashMap<String, ConnectionManager>();
    private TransactionManager tm = null;
    private TreeSet<IManagedConnection> freeList = new TreeSet();
    private LinkedList<IManagedConnection> mcList = new LinkedList();
    private Map<Transaction, IManagedConnection> tx2mc = new HashMap<Transaction, IManagedConnection>();
    private int loginTimeout = 60;
    private PrintWriter log = null;
    private String dSName = null;
    private String dataSourceName;
    private String url = null;
    private String className = null;
    private String userName = null;
    private String password = null;
    private int isolationLevel = -1;
    private String isolationStr = null;
    private int waiterCount = 0;
    private long waitingTime = 0L;
    private int busyMax = 0;
    private int busyMin = 0;
    private static final int NO_LIMIT = 99999;
    private static final long ONE_DAY = 86400000L;
    private static final int MAX_REMOVE_FREELIST = 10;
    private int poolMin = 0;
    private int poolMax = 99999;
    private long maxAge = 86400000L;
    private int maxAgeMn;
    private long maxOpenTime = 86400000L;
    private int maxOpenTimeMn;
    private long waiterTimeout = 10000L;
    private int maxWaiters = 1000;
    private int samplingPeriod = 60;
    private int checkLevel = 0;
    private int pstmtMax = 12;
    private String testStatement;
    private int busyMaxRecent = 0;
    private int busyMinRecent = 0;
    private int currentWaiters = 0;
    private int openedCount = 0;
    private int connectionFailures = 0;
    private int connectionLeaks = 0;
    private int servedOpen = 0;
    private int rejectedFull = 0;
    private int rejectedTimeout = 0;
    private int rejectedOther = 0;
    private int waitersHigh = 0;
    private int waitersHighRecent = 0;
    private int totalWaiterCount = 0;
    private long totalWaitingTime = 0L;
    private long waitingHigh = 0L;
    private long waitingHighRecent = 0L;

    public static ConnectionManager getConnectionManager(String dsname) {
        ConnectionManager cm = cmList.get(dsname);
        return cm;
    }

    public String getDSName() {
        return this.dSName;
    }

    public void setDSName(String s) {
        this.dSName = s;
        cmList.put(s, this);
    }

    public String getDatasourceName() {
        return this.dataSourceName;
    }

    public void setDatasourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) throws ClassNotFoundException {
        this.className = className;
        this.logger.debug((Object)"Load JDBC driver {0}", new Object[]{className});
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)"Cannot load JDBC driver", new Object[]{e});
            throw e;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTransactionIsolation(String level) {
        if (level.equals("serializable")) {
            this.isolationLevel = 8;
        } else if (level.equals("none")) {
            this.isolationLevel = 0;
        } else if (level.equals("read_committed")) {
            this.isolationLevel = 2;
        } else if (level.equals("read_uncommitted")) {
            this.isolationLevel = 1;
        } else if (level.equals("repeatable_read")) {
            this.isolationLevel = 4;
        } else {
            this.isolationStr = "default";
            return;
        }
        this.isolationStr = level;
    }

    public String getTransactionIsolation() {
        return this.isolationStr;
    }

    public synchronized int getPoolMin() {
        return this.poolMin;
    }

    public synchronized void setPoolMin(int min) {
        if (this.poolMin != min) {
            this.poolMin = min;
            this.adjust();
        }
    }

    public synchronized int getPoolMax() {
        return this.poolMax;
    }

    public synchronized void setPoolMax(int max) {
        if (this.poolMax != max) {
            if (max < 0 || max > 99999) {
                if (this.currentWaiters > 0) {
                    this.notify();
                }
                this.poolMax = 99999;
            } else {
                if (this.currentWaiters > 0 && this.poolMax < max) {
                    this.notify();
                }
                this.poolMax = max;
                this.adjust();
            }
        }
    }

    public int getMaxAge() {
        return this.maxAgeMn;
    }

    public long getMaxAgeMilli() {
        return this.maxAge;
    }

    public void setMaxAge(int mn) {
        this.maxAgeMn = mn;
        this.maxAge = (long)mn * 60000L;
    }

    public int getMaxOpenTime() {
        return this.maxOpenTimeMn;
    }

    public long getMaxOpenTimeMilli() {
        return this.maxOpenTime;
    }

    public void setMaxOpenTime(int mn) {
        this.maxOpenTimeMn = mn;
        this.maxOpenTime = (long)mn * 60000L;
    }

    public int getMaxWaitTime() {
        return (int)(this.waiterTimeout / 1000L);
    }

    public void setMaxWaitTime(int sec) {
        this.waiterTimeout = (long)sec * 1000L;
    }

    public int getMaxWaiters() {
        return this.maxWaiters;
    }

    public void setMaxWaiters(int nb) {
        this.maxWaiters = nb;
    }

    public int getSamplingPeriod() {
        return this.samplingPeriod;
    }

    public void setSamplingPeriod(int sec) {
        if (sec > 0) {
            this.samplingPeriod = sec;
        }
    }

    public int getCheckLevel() {
        return this.checkLevel;
    }

    public void setCheckLevel(int level) {
        this.checkLevel = level;
    }

    public int getPstmtMax() {
        return this.pstmtMax;
    }

    public void setPstmtMax(int nb) {
        this.pstmtMax = nb;
        for (IManagedConnection mc : this.mcList) {
            mc.setPstmtMax(this.pstmtMax);
        }
    }

    public String getTestStatement() {
        return this.testStatement;
    }

    public void setTestStatement(String s) {
        this.testStatement = s;
    }

    public void poolConfigure(String connchecklevel, String connmaxage, String maxopentime, String connteststmt, String pstmtmax, String minconpool, String maxconpool, String maxwaittime, String maxwaiters, String samplingperiod) {
        this.setCheckLevel(new Integer(connchecklevel));
        this.setMaxAge(new Integer(connmaxage));
        this.setMaxOpenTime(new Integer(maxopentime));
        this.setTestStatement(connteststmt);
        this.setPstmtMax(new Integer(pstmtmax));
        this.setPoolMin(new Integer(minconpool));
        this.setPoolMax(new Integer(maxconpool));
        this.setMaxWaitTime(new Integer(maxwaittime));
        this.setMaxWaiters(new Integer(maxwaiters));
        this.setSamplingPeriod(new Integer(samplingperiod));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"ConnectionManager configured with:", new Object[0]);
            this.logger.debug((Object)"   jdbcConnCheckLevel  = {0}", new Object[]{connchecklevel});
            this.logger.debug((Object)"   jdbcConnMaxAge      = {0}", new Object[]{connmaxage});
            this.logger.debug((Object)"   jdbcMaxOpenTime     = {0}", new Object[]{maxopentime});
            this.logger.debug((Object)"   jdbcTestStmt        = {0}", new Object[]{connteststmt});
            this.logger.debug((Object)"   jdbcPstmtMax        = {0}", new Object[]{pstmtmax});
            this.logger.debug((Object)"   minConPool          = {0}", new Object[]{this.getPoolMin()});
            this.logger.debug((Object)"   maxConPool          = {0}", new Object[]{this.getPoolMax()});
            this.logger.debug((Object)"   maxWaitTime         = {0}", new Object[]{this.getMaxWaitTime()});
            this.logger.debug((Object)"   maxWaiters          = {0}", new Object[]{this.getMaxWaiters()});
            this.logger.debug((Object)"   samplingPeriod      = {0}", new Object[]{this.getSamplingPeriod()});
        }
    }

    public int getBusyMaxRecent() {
        return this.busyMaxRecent;
    }

    public int getBusyMinRecent() {
        return this.busyMinRecent;
    }

    public int getCurrentWaiters() {
        return this.currentWaiters;
    }

    public int getOpenedCount() {
        return this.openedCount;
    }

    public int getConnectionFailures() {
        return this.connectionFailures;
    }

    public int getConnectionLeaks() {
        return this.connectionLeaks;
    }

    public int getServedOpen() {
        return this.servedOpen;
    }

    public int getRejectedFull() {
        return this.rejectedFull;
    }

    public int getRejectedTimeout() {
        return this.rejectedTimeout;
    }

    public int getRejectedOther() {
        return this.rejectedOther;
    }

    public int getRejectedOpen() {
        return this.rejectedFull + this.rejectedTimeout + this.rejectedOther;
    }

    public int getWaitersHigh() {
        return this.waitersHigh;
    }

    public int getWaitersHighRecent() {
        return this.waitersHighRecent;
    }

    public int getWaiterCount() {
        return this.totalWaiterCount;
    }

    public long getWaitingTime() {
        return this.totalWaitingTime;
    }

    public long getWaitingHigh() {
        return this.waitingHigh;
    }

    public long getWaitingHighRecent() {
        return this.waitingHighRecent;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.log = out;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        IManagedConnection mc = null;
        Transaction tx = null;
        try {
            tx = this.tm.getTransaction();
        }
        catch (NullPointerException n) {
            this.logger.error((Object)"ConnectionManager: should not be used outside a EasyBeans Server", new Object[0]);
        }
        catch (SystemException e) {
            this.logger.error((Object)"ConnectionManager: getTransaction failed", new Object[]{e});
        }
        this.logger.debug((Object)"Tx = {0}", new Object[]{tx});
        mc = this.openConnection(username, tx);
        Connection ret = mc.getConnection();
        if (tx != null) {
            if (mc.getOpenCount() == 1) {
                try {
                    this.logger.debug((Object)"enlist XAResource on {0}", new Object[]{tx});
                    tx.enlistResource(mc.getXAResource());
                    ret.setAutoCommit(false);
                }
                catch (RollbackException e) {
                    this.logger.warn((Object)"XAResource enlisted, but tx is marked rollback", new Object[]{e});
                }
                catch (IllegalStateException e) {
                    ret.setAutoCommit(true);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Cannot enlist XAResource", new Object[]{e});
                    this.logger.error((Object)"Connection will not be enlisted in a transaction", new Object[0]);
                    throw new SQLException("Cannot enlist XAResource");
                }
            }
        } else {
            ret.setAutoCommit(true);
        }
        return ret;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.userName, this.password);
    }

    @Override
    public XAConnection getXAConnection(String user, String passwd) throws SQLException {
        Connection conn = null;
        try {
            if (user.length() == 0) {
                conn = DriverManager.getConnection(this.url);
                this.logger.debug((Object)"    * New Connection on {0}", new Object[]{this.url});
            } else {
                conn = DriverManager.getConnection(this.url, user, passwd);
                this.logger.debug((Object)"    * New Connection on {0} for user {1}", new Object[]{this.url, user});
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"Could not get Connection on {0}", new Object[]{this.url, e});
            throw new SQLException("Could not get Connection on url : " + this.url + " for user : " + user + " inner exception" + e.getMessage());
        }
        if (this.isolationLevel != -1) {
            try {
                this.logger.debug((Object)"set transaction isolation to {0}", new Object[]{this.isolationLevel});
                conn.setTransactionIsolation(this.isolationLevel);
            }
            catch (SQLException e) {
                String ilstr = "?";
                switch (this.isolationLevel) {
                    case 8: {
                        ilstr = "SERIALIZABLE";
                        break;
                    }
                    case 0: {
                        ilstr = "NONE";
                        break;
                    }
                    case 2: {
                        ilstr = "READ_COMMITTED";
                        break;
                    }
                    case 1: {
                        ilstr = "READ_UNCOMMITTED";
                        break;
                    }
                    case 4: {
                        ilstr = "REPEATABLE_READ";
                        break;
                    }
                    default: {
                        throw new SQLException("Invalid isolation level '" + ilstr + "'.");
                    }
                }
                this.logger.error((Object)"Cannot set transaction isolation to {0} for this DataSource url {1}", new Object[]{ilstr, this.url, e});
                this.isolationLevel = -1;
            }
        }
        IManagedConnection mc = (IManagedConnection)Proxy.newProxyInstance(IManagedConnection.class.getClassLoader(), new Class[]{IManagedConnection.class}, (InvocationHandler)new JManagedConnection(conn, this));
        return mc;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), DataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("datasource.name", this.getDSName()));
        ref.add(new StringRefAddr("datasource.url", this.getUrl()));
        ref.add(new StringRefAddr("datasource.classname", this.getClassName()));
        ref.add(new StringRefAddr("datasource.username", this.getUserName()));
        ref.add(new StringRefAddr("datasource.password", this.getPassword()));
        ref.add(new StringRefAddr("datasource.isolationlevel", this.getTransactionIsolation()));
        Integer checklevel = this.getCheckLevel();
        ref.add(new StringRefAddr("connchecklevel", checklevel.toString()));
        Integer maxage = this.getMaxAge();
        ref.add(new StringRefAddr("connmaxage", maxage.toString()));
        Integer maxopentime = this.getMaxOpenTime();
        ref.add(new StringRefAddr("maxopentime", maxopentime.toString()));
        ref.add(new StringRefAddr("connteststmt", this.getTestStatement()));
        Integer pstmtmax = this.getPstmtMax();
        ref.add(new StringRefAddr("pstmtmax", pstmtmax.toString()));
        Integer minpool = this.getPoolMin();
        ref.add(new StringRefAddr("minconpool", minpool.toString()));
        Integer maxpool = this.getPoolMax();
        ref.add(new StringRefAddr("maxconpool", maxpool.toString()));
        Integer maxwaittime = this.getMaxWaitTime();
        ref.add(new StringRefAddr("maxwaittime", maxwaittime.toString()));
        Integer maxwaiters = this.getMaxWaiters();
        ref.add(new StringRefAddr("maxwaiters", maxwaiters.toString()));
        Integer samplingperiod = this.getSamplingPeriod();
        ref.add(new StringRefAddr("samplingperiod", samplingperiod.toString()));
        return ref;
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        IManagedConnection mc = (IManagedConnection)event.getSource();
        this.closeConnection(mc, 0x4000000);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        IManagedConnection mc = (IManagedConnection)event.getSource();
        this.logger.debug((Object)"mc= {0}", new Object[]{mc.getIdentifier()});
        this.closeConnection(mc, 0x20000000);
    }

    public int getCurrentOpened() {
        return this.mcList.size();
    }

    public int getCurrentBusy() {
        return this.mcList.size() - this.freeList.size();
    }

    public void recomputeBusy() {
        int busy = this.getCurrentBusy();
        if (this.busyMax < busy) {
            this.busyMax = busy;
        }
        if (this.busyMin > busy) {
            this.busyMin = busy;
        }
    }

    public int getCurrentInTx() {
        return this.tx2mc.size();
    }

    public synchronized void sampling() {
        this.waitingHighRecent = this.waitingTime;
        if (this.waitingHigh < this.waitingTime) {
            this.waitingHigh = this.waitingTime;
        }
        this.waitingTime = 0L;
        this.waitersHighRecent = this.waiterCount;
        if (this.waitersHigh < this.waiterCount) {
            this.waitersHigh = this.waiterCount;
        }
        this.waiterCount = 0;
        this.busyMaxRecent = this.busyMax;
        this.busyMax = this.getCurrentBusy();
        this.busyMinRecent = this.busyMin;
        this.busyMin = this.getCurrentBusy();
    }

    public synchronized void adjust() {
        IManagedConnection mc;
        IManagedConnection mc2;
        Iterator<Object> i;
        this.logger.debug((Object)this.dSName, new Object[0]);
        int count = this.mcList.size() - this.poolMin;
        if (count >= 0) {
            if (count > 10) {
                count = 10;
            }
            i = this.freeList.iterator();
            while (i.hasNext()) {
                mc2 = (IManagedConnection)i.next();
                if (!mc2.isAged()) continue;
                this.logger.debug((Object)"remove a timed out connection", new Object[0]);
                i.remove();
                this.destroyItem(mc2);
                if (--count > 0) continue;
                break;
            }
        }
        this.recomputeBusy();
        i = this.mcList.iterator();
        while (i.hasNext()) {
            mc2 = (IManagedConnection)i.next();
            if (!mc2.inactive()) continue;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"close a timed out open connection {0}", new Object[]{mc2.getIdentifier()});
            }
            i.remove();
            mc2.remove();
            ++this.connectionLeaks;
            if (this.currentWaiters <= 0) continue;
            this.notify();
        }
        if (this.poolMax != 99999) {
            while (this.freeList.size() > this.poolMin && this.mcList.size() > this.poolMax) {
                mc = this.freeList.first();
                this.freeList.remove(mc);
                this.destroyItem(mc);
            }
        }
        this.recomputeBusy();
        while (this.mcList.size() < this.poolMin) {
            mc = null;
            try {
                mc = (IManagedConnection)this.getXAConnection();
                ++this.openedCount;
            }
            catch (SQLException e) {
                throw new IllegalStateException("Could not create " + this.poolMin + " mcs in the pool : ", e);
            }
            this.freeList.add(mc);
            this.mcList.add(mc);
            mc.addConnectionEventListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IManagedConnection openConnection(String user, Transaction tx) throws SQLException {
        IManagedConnection mc = null;
        if (tx != null && (mc = this.tx2mc.get(tx)) != null) {
            this.logger.debug((Object)"Reuse a Connection for same tx", new Object[0]);
            mc.hold();
            ++this.servedOpen;
            return mc;
        }
        long timetowait = this.waiterTimeout;
        long starttime = 0L;
        while (mc == null) {
            if (this.freeList.isEmpty()) {
                if (this.mcList.size() >= this.poolMax) {
                    boolean stoplooping = true;
                    if (timetowait > 0L && this.currentWaiters < this.maxWaiters) {
                        ++this.currentWaiters;
                        if (this.waiterCount < this.currentWaiters) {
                            this.waiterCount = this.currentWaiters;
                        }
                        if (starttime == 0L) {
                            starttime = System.currentTimeMillis();
                            this.logger.debug((Object)"Wait for a free Connection, {0}", new Object[]{this.mcList.size()});
                        }
                        try {
                            this.wait(timetowait);
                        }
                        catch (InterruptedException ign) {
                            this.logger.warn((Object)"Interrupted", new Object[0]);
                        }
                        finally {
                            --this.currentWaiters;
                        }
                        long stoptime = System.currentTimeMillis();
                        long stillwaited = stoptime - starttime;
                        timetowait = this.waiterTimeout - stillwaited;
                        boolean bl = stoplooping = timetowait <= 0L;
                        if (stoplooping) {
                            ++this.totalWaiterCount;
                            this.totalWaitingTime += stillwaited;
                            if (this.waitingTime < stillwaited) {
                                this.waitingTime = stillwaited;
                            }
                        } else {
                            if (this.freeList.isEmpty() && this.mcList.size() >= this.poolMax) continue;
                            this.logger.debug((Object)"Notified after {0}", new Object[]{stillwaited});
                            ++this.totalWaiterCount;
                            this.totalWaitingTime += stillwaited;
                            if (this.waitingTime >= stillwaited) continue;
                            this.waitingTime = stillwaited;
                            continue;
                        }
                    }
                    if (!stoplooping || !this.freeList.isEmpty() || this.mcList.size() < this.poolMax) continue;
                    if (starttime > 0L) {
                        ++this.rejectedTimeout;
                        this.logger.warn((Object)"Cannot create a Connection - timeout", new Object[0]);
                    } else {
                        ++this.rejectedFull;
                        this.logger.warn((Object)"Cannot create a Connection", new Object[0]);
                    }
                    throw new SQLException("No more connections in " + this.getDatasourceName());
                }
                this.logger.debug((Object)"empty free list: Create a new Connection", new Object[0]);
                try {
                    mc = (IManagedConnection)this.getXAConnection();
                    ++this.openedCount;
                }
                catch (SQLException e) {
                    ++this.connectionFailures;
                    ++this.rejectedOther;
                    this.logger.warn((Object)"Cannot create new Connection for tx", new Object[]{e});
                    throw e;
                }
                mc.addConnectionEventListener(this);
                this.mcList.add(mc);
                continue;
            }
            mc = this.freeList.last();
            this.freeList.remove(mc);
            if (this.checkLevel <= 0) continue;
            try {
                IConnection conn = (IConnection)mc.getConnection();
                if (conn.isPhysicallyClosed()) {
                    this.logger.warn((Object)"The JDBC connection has been closed!", new Object[0]);
                    this.destroyItem(mc);
                    starttime = 0L;
                    mc = null;
                    continue;
                }
                if (this.checkLevel <= 1) continue;
                Statement stmt = conn.createStatement();
                stmt.execute(this.testStatement);
                stmt.close();
            }
            catch (Exception e) {
                this.logger.error((Object)("DataSource " + this.getDatasourceName() + " error: removing invalid mc"), new Object[]{e});
                this.destroyItem(mc);
                starttime = 0L;
                mc = null;
            }
        }
        this.recomputeBusy();
        mc.setTx(tx);
        if (tx == null) {
            this.logger.debug((Object)"Got a Connection - no TX: ", new Object[0]);
        } else {
            this.logger.debug((Object)"Got a Connection for TX: ", new Object[0]);
            try {
                tx.registerSynchronization((Synchronization)mc);
                this.tx2mc.put(tx, mc);
            }
            catch (RollbackException e) {
                this.logger.warn((Object)("DataSource " + this.getDatasourceName() + " error: Pool mc registered, but tx is rollback only"), new Object[]{e});
            }
            catch (SystemException e) {
                this.logger.error((Object)("DataSource " + this.getDatasourceName() + " error in pool: system exception from transaction manager "), new Object[]{e});
            }
            catch (IllegalStateException e) {
                this.logger.warn((Object)"Got a Connection - committed TX: ", new Object[]{e});
                mc.setTx(null);
            }
        }
        mc.hold();
        ++this.servedOpen;
        return mc;
    }

    public synchronized void freeConnections(Transaction tx) {
        this.logger.debug((Object)("free connection for Tx = " + tx), new Object[0]);
        IManagedConnection mc = this.tx2mc.remove(tx);
        if (mc == null) {
            this.logger.error((Object)("pool: no connection found to free for Tx = " + tx), new Object[0]);
            return;
        }
        mc.setTx(null);
        if (mc.isOpen()) {
            this.logger.debug((Object)"Connection not closed by caller", new Object[0]);
            return;
        }
        this.freeItem(mc);
    }

    public synchronized void closeAllConnection() {
        Iterator it = this.mcList.iterator();
        try {
            while (it.hasNext()) {
                IManagedConnection mc = (IManagedConnection)it.next();
                mc.close();
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"Error while closing a Connection:", new Object[]{e});
        }
    }

    private boolean closeConnection(IManagedConnection mc, int flag) {
        if (!mc.release()) {
            return false;
        }
        if (mc.getTx() != null) {
            this.logger.debug((Object)"keep connection for same tx", new Object[0]);
        } else {
            this.freeItem(mc);
        }
        Transaction tx = null;
        try {
            tx = this.tm.getTransaction();
        }
        catch (NullPointerException n) {
            this.logger.error((Object)"Pool: should not be used outside a EasyBeans Server", new Object[]{n});
        }
        catch (SystemException e) {
            this.logger.error((Object)"Pool: getTransaction failed:", new Object[]{e});
        }
        if (tx != null && mc.isClosed()) {
            try {
                tx.delistResource(mc.getXAResource(), flag);
            }
            catch (Exception e) {
                this.logger.error((Object)"Pool: Exception while delisting resource:", new Object[]{e});
            }
        }
        return true;
    }

    private synchronized void freeItem(IManagedConnection item) {
        this.freeList.add(item);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("item added to freeList: " + item.getIdentifier()), new Object[0]);
        }
        if (this.currentWaiters > 0) {
            this.notify();
        }
        this.recomputeBusy();
    }

    private synchronized void destroyItem(IManagedConnection mc) {
        this.mcList.remove(mc);
        mc.remove();
        if (this.currentWaiters > 0) {
            this.notify();
        }
        this.recomputeBusy();
    }

    /*
     * WARNING - void declaration
     */
    public String checkConnection(String testStatement) throws SQLException {
        void var3_10;
        Connection conn;
        void var3_8;
        String noError = testStatement;
        Object var3_3 = null;
        boolean jmcCreated = false;
        if (!this.freeList.isEmpty()) {
            for (IManagedConnection iManagedConnection : this.freeList) {
                try {
                    IConnection conn2 = (IConnection)iManagedConnection.getConnection();
                    if (!conn2.isPhysicallyClosed()) {
                        this.logger.debug((Object)("Use a free IManagedConnection to test with " + testStatement), new Object[0]);
                        break;
                    }
                    Object var3_6 = null;
                }
                catch (SQLException e) {
                    Object var3_7 = null;
                }
            }
        }
        if (var3_8 == null) {
            this.logger.debug((Object)("Create a IManagedConnection to test with " + testStatement), new Object[0]);
            conn = null;
            try {
                conn = DriverManager.getConnection(this.url, this.userName, this.password);
            }
            catch (SQLException e) {
                this.logger.error((Object)("Could not get Connection on " + this.url + ":"), new Object[]{e});
            }
            IManagedConnection iManagedConnection = (IManagedConnection)Proxy.newProxyInstance(IManagedConnection.class.getClassLoader(), new Class[]{IManagedConnection.class}, (InvocationHandler)new JManagedConnection(conn, this));
            jmcCreated = true;
        }
        if (var3_10 != null) {
            conn = var3_10.getConnection();
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(testStatement);
            }
            catch (SQLException e) {
                return e.getMessage();
            }
            stmt.close();
            if (jmcCreated) {
                var3_10.close();
            }
        }
        return noError;
    }

    protected void setTm(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

