/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jdbcpool;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.ow2.easybeans.component.jdbcpool.ConnectionManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceFactory
implements ObjectFactory {
    private static Log logger = LogFactory.getLog(DataSourceFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String dsname = (String)ref.get("datasource.name").getContent();
        ConnectionManager ds = ConnectionManager.getConnectionManager(dsname);
        if (ds == null) {
            logger.debug((Object)"Creating a new Connection Manager for {0}", new Object[]{dsname});
            try {
                ds = new ConnectionManager();
                ds.setDSName(dsname);
                ds.setUrl((String)ref.get("datasource.url").getContent());
                ds.setClassName((String)ref.get("datasource.classname").getContent());
                ds.setUserName((String)ref.get("datasource.username").getContent());
                ds.setPassword((String)ref.get("datasource.password").getContent());
                ds.setTransactionIsolation((String)ref.get("datasource.isolationlevel").getContent());
                ds.poolConfigure((String)ref.get("connchecklevel").getContent(), (String)ref.get("connmaxage").getContent(), (String)ref.get("maxopentime").getContent(), (String)ref.get("connteststmt").getContent(), (String)ref.get("pstmtmax").getContent(), (String)ref.get("minconpool").getContent(), (String)ref.get("maxconpool").getContent(), (String)ref.get("maxwaittime").getContent(), (String)ref.get("maxwaiters").getContent(), (String)ref.get("samplingperiod").getContent());
            }
            catch (Exception e) {
                logger.error((Object)"DataSourceFactory error", new Object[]{e});
            }
        }
        return ds;
    }
}

