/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jdbcpool;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.ow2.easybeans.component.jdbcpool.AbsProxy;
import org.ow2.easybeans.component.jdbcpool.IManagedConnection;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JConnection
extends AbsProxy {
    private static Log logger = LogFactory.getLog(JConnection.class);
    private Connection physicalConnection = null;
    private IManagedConnection xaConnection = null;
    private static Method prepareStatementMethod = null;

    public JConnection(IManagedConnection xaConnection, Connection physicalConnection) {
        this.xaConnection = xaConnection;
        this.physicalConnection = physicalConnection;
    }

    public Connection getConnection() {
        return this.physicalConnection;
    }

    public boolean isPhysicallyClosed() throws SQLException {
        return this.physicalConnection.isClosed();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
            return this.handleObjectMethods(method, args);
        }
        if ("getConnection".equals(method.getName())) {
            return this.getConnection();
        }
        if ("isPhysicallyClosed".equals(method.getName())) {
            return this.isPhysicallyClosed();
        }
        if ("close".equals(method.getName())) {
            this.xaConnection.notifyClose();
            return null;
        }
        if ("prepareStatement".equals(method.getName()) && method.getParameterTypes().length == 1) {
            try {
                return JConnection.getPrepareStatementMethod().invoke((Object)this.xaConnection, args);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof SQLException) {
                    logger.debug((Object)"Exception while calling method {0} on object {1}", new Object[]{method, this.xaConnection});
                    this.xaConnection.notifyError((SQLException)targetException);
                }
                throw targetException;
            }
        }
        try {
            return method.invoke((Object)this.physicalConnection, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof SQLException) {
                logger.debug((Object)"Exception while calling method {0} on object {1}", new Object[]{method, this.physicalConnection});
                this.xaConnection.notifyError((SQLException)targetException);
            }
            throw targetException;
        }
    }

    protected static Method getPrepareStatementMethod() {
        if (prepareStatementMethod != null) {
            return prepareStatementMethod;
        }
        try {
            prepareStatementMethod = IManagedConnection.class.getMethod("prepareStatement", String.class);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot find the prepareStatement method on XAConnection interface", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot find the prepareStatement method on XAConnection interface", e);
        }
        return prepareStatementMethod;
    }
}

