/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jdbcpool;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.TMComponent;
import org.ow2.easybeans.component.jdbcpool.ConnectionManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JDBCPoolComponent
implements EZBComponent {
    private static Log logger = LogFactory.getLog(JDBCPoolComponent.class);
    private static final String DEFAULT_USER = "";
    private static final String DEFAULT_PASSWORD = "";
    private static final int DEFAULT_MIN_POOL = 10;
    private static final int DEFAULT_MAX_POOL = 30;
    private static final int DEFAULT_PSTMT = 10;
    private static final int DEFAULT_CHECK_LEVEL = 0;
    private static final String DEFAULT_TEST_STATEMENT_HSQLDB = "select 1 from INFORMATION_SCHEMA.SYSTEM_USERS";
    private int checkLevel = 0;
    private ConnectionManager connectionManager = null;
    private String jndiName = null;
    private String username = "";
    private String password = "";
    private String url = null;
    private String driver = null;
    private boolean useTM = true;
    private int poolMin = 10;
    private int poolMax = 30;
    private int pstmtMax = 10;
    private String testStatement = "select 1 from INFORMATION_SCHEMA.SYSTEM_USERS";
    private TMComponent transactionComponent = null;

    public void init() throws EZBComponentException {
        this.connectionManager = new ConnectionManager();
        this.connectionManager.setTransactionIsolation("default");
        this.validate();
        this.connectionManager.setDatasourceName(this.jndiName);
        this.connectionManager.setDSName(this.jndiName);
        this.connectionManager.setUrl(this.url);
        try {
            this.connectionManager.setClassName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load jdbc driver '" + this.driver + "'.", e);
        }
        this.connectionManager.setUserName(this.username);
        this.connectionManager.setPassword(this.password);
        this.connectionManager.setTransactionIsolation("default");
        this.connectionManager.setPstmtMax(this.pstmtMax);
        this.connectionManager.setCheckLevel(this.checkLevel);
        this.connectionManager.setTestStatement(this.testStatement);
    }

    private void validate() throws EZBComponentException {
        if (this.jndiName == null) {
            throw new EZBComponentException("No JNDI name set");
        }
        if (this.url == null) {
            throw new EZBComponentException("No URL set");
        }
        if (this.driver == null) {
            throw new EZBComponentException("No driver set");
        }
    }

    public void start() throws EZBComponentException {
        if (this.useTM) {
            if (this.transactionComponent == null) {
                throw new EZBComponentException("Transaction component was not injected. Reason: Missing tm=\"#tm\" in the easybeans.xml configuration file ?");
            }
            this.connectionManager.setTm(this.transactionComponent.getTransactionManager());
        }
        this.connectionManager.setPoolMin(this.poolMin);
        this.connectionManager.setPoolMax(this.poolMax);
        try {
            Object o = new InitialContext().lookup(this.jndiName);
            if (o != null) {
                logger.warn((Object)"Entry with JNDI name {0} already exist", new Object[]{this.jndiName});
            }
        }
        catch (NamingException e) {
            logger.debug((Object)"Nothing with JNDI name {0}", new Object[]{this.jndiName});
        }
        try {
            new InitialContext().rebind(this.jndiName, (Object)this.connectionManager);
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot bind a JDBC Datasource with the jndi name '" + this.jndiName + "'.");
        }
        logger.info((Object)"DS ''{0}'', URL ''{1}'', Driver = ''{2}''.", new Object[]{this.jndiName, this.url, this.driver});
    }

    public void stop() throws EZBComponentException {
        try {
            new InitialContext().unbind(this.jndiName);
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot unbind a JDBC Datasource with the jndi name '" + this.jndiName + "'.");
        }
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPoolMax(int poolMax) {
        this.poolMax = poolMax;
    }

    public int getPoolMax() {
        return this.poolMax;
    }

    public void setPoolMin(int poolMin) {
        this.poolMin = poolMin;
    }

    public int getPoolMin() {
        return this.poolMax;
    }

    public void setPstmtMax(int pstmtMax) {
        this.pstmtMax = pstmtMax;
    }

    public int getPstmtMax() {
        return this.poolMax;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUseTM(boolean useTM) {
        this.useTM = useTM;
    }

    public boolean isUseTM() {
        return this.useTM;
    }

    public int getCheckLevel() {
        return this.checkLevel;
    }

    public void setCheckLevel(int checkLevel) {
        this.checkLevel = checkLevel;
    }

    public String getTestStatement() {
        return this.testStatement;
    }

    public void setTestStatement(String testStatement) {
        this.testStatement = testStatement;
    }

    public TMComponent getTransactionComponent() {
        return this.transactionComponent;
    }

    public void setTransactionComponent(TMComponent transactionComponent) {
        this.transactionComponent = transactionComponent;
    }
}

