/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jmx;

import java.util.LinkedList;
import java.util.List;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBJ2EEManagedObject;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.jmx.EZBMBeanAttribute;
import org.ow2.easybeans.api.jmx.EZBMBeanOperation;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.EZBJmxComponent;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.util.jmx.api.IBaseModelMBeanExt;
import org.ow2.util.jmx.api.ICommonsModelerExtService;
import org.ow2.util.jmx.api.IMBeanAttribute;
import org.ow2.util.jmx.api.IMBeanOperation;
import org.ow2.util.jmx.impl.CommonsModelerExtService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxComponent
implements EZBJmxComponent {
    private ICommonsModelerExtService service;
    private LinkedList<IMBeanAttribute> attributes = new LinkedList();
    private LinkedList<IMBeanOperation> operations = new LinkedList();
    private LinkedList<EZBJ2EEManagedObject> objects = new LinkedList();

    public synchronized void init() throws EZBComponentException {
        if (this.service == null) {
            this.service = new CommonsModelerExtService();
            this.service.start();
        }
    }

    public synchronized void start() throws EZBComponentException {
    }

    public synchronized void stop() throws EZBComponentException {
        for (IMBeanAttribute attribute : this.attributes) {
            this.service.unregisterAttribute(attribute);
        }
        for (IMBeanOperation operation : this.operations) {
            this.service.unregisterOperation(operation);
        }
        for (EZBJ2EEManagedObject object : this.objects) {
            this.service.unregisterBaseModelMBeanExt(object.getJ2EEManagedObjectId());
        }
        this.attributes.clear();
        this.operations.clear();
        this.objects.clear();
    }

    public synchronized void setCommonsModelerExtService(ICommonsModelerExtService service) {
        this.service = service;
    }

    public synchronized void registerJ2EEManagedObject(EZBJ2EEManagedObject object, IBaseModelMBeanExt mbean) {
        if (EZBServer.class.isAssignableFrom(object.getClass())) {
            this.registerEZBServer((EZBServer)object, mbean);
        } else if (EZBContainer.class.isAssignableFrom(object.getClass())) {
            this.registerEZBContainer((EZBContainer)object, mbean);
        } else if (Factory.class.isAssignableFrom(object.getClass())) {
            this.registerEZBFactory((Factory)object, mbean);
        }
    }

    public synchronized void unregisterJ2EEManagedObject(EZBJ2EEManagedObject object) {
        if (EZBServer.class.isAssignableFrom(object.getClass())) {
            this.unregisterEZBServer((EZBServer)object);
        } else if (EZBContainer.class.isAssignableFrom(object.getClass())) {
            this.unregisterEZBContainer((EZBContainer)object);
        } else if (Factory.class.isAssignableFrom(object.getClass())) {
            this.unregisterEZBFactory((Factory)object);
        }
    }

    public synchronized void registerMBeanAttribute(EZBMBeanAttribute mbeanAttribute) {
        this.service.registerAttribute((IMBeanAttribute)mbeanAttribute, mbeanAttribute.getMBeanProviderFilter());
        this.attributes.add((IMBeanAttribute)mbeanAttribute);
    }

    public synchronized void unregisterMBeanAttribute(EZBMBeanAttribute mbeanAttribute) {
        this.service.unregisterAttribute((IMBeanAttribute)mbeanAttribute);
        this.attributes.remove(mbeanAttribute);
    }

    public synchronized void registerMBeanOperation(EZBMBeanOperation mbeanOperation) {
        this.service.registerOperation((IMBeanOperation)mbeanOperation, mbeanOperation.getMBeanProviderFilter());
        this.operations.add((IMBeanOperation)mbeanOperation);
    }

    public synchronized void unregisterMBeanOperation(EZBMBeanOperation mbeanOperation) {
        this.service.unregisterOperation((IMBeanOperation)mbeanOperation);
        this.operations.remove(mbeanOperation);
    }

    private void registerEZBServer(EZBServer server, IBaseModelMBeanExt mbean) {
        this.service.registerBaseModelMBeanExt(server.getJ2EEManagedObjectId(), mbean);
        this.objects.add((EZBJ2EEManagedObject)server);
    }

    private void unregisterEZBServer(EZBServer server) {
        this.service.unregisterBaseModelMBeanExt(server.getJ2EEManagedObjectId());
        this.objects.remove(server);
    }

    private void registerEZBContainer(EZBContainer container, IBaseModelMBeanExt mbean) {
        this.service.registerBaseModelMBeanExt(container.getJ2EEManagedObjectId(), mbean);
        this.objects.add((EZBJ2EEManagedObject)container);
    }

    private void unregisterEZBContainer(EZBContainer container) {
        this.service.unregisterBaseModelMBeanExt(container.getJ2EEManagedObjectId());
        this.objects.remove(container);
    }

    private void registerEZBFactory(Factory<?, ?> factory, IBaseModelMBeanExt mbean) {
        this.service.registerBaseModelMBeanExt(factory.getJ2EEManagedObjectId(), mbean);
        this.objects.add((EZBJ2EEManagedObject)factory);
        List methods = J2EEManagedObjectNamingHelper.getBeanMethodsManagedObjectIds(factory);
        for (String method : methods) {
            this.service.registerBaseModelMBeanExt(method, mbean);
        }
    }

    private void unregisterEZBFactory(Factory<?, ?> factory) {
        this.service.unregisterBaseModelMBeanExt(factory.getJ2EEManagedObjectId());
        this.objects.remove(factory);
        List methods = J2EEManagedObjectNamingHelper.getBeanMethodsManagedObjectIds(factory);
        for (String method : methods) {
            this.service.unregisterBaseModelMBeanExt(method);
        }
    }
}

