/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jotm;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.XATerminator;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.Jotm;
import org.objectweb.jotm.TimerManager;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.TMComponent;
import org.ow2.easybeans.transaction.JTransactionManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOTMComponent
implements TMComponent {
    private static final int DEFAULT_TIMEOUT = 60;
    private static Log logger = LogFactory.getLog(JOTMComponent.class);
    private Jotm jotm = null;
    private TransactionManager tm = null;
    private int timeout = 60;

    public void init() throws EZBComponentException {
    }

    public void start() throws EZBComponentException {
        try {
            this.tm = (TransactionManager)new InitialContext().lookup("javax.transaction.UserTransaction");
        }
        catch (NamingException e) {
            logger.debug((Object)"tm not available", new Object[0]);
        }
        if (this.tm != null) {
            logger.info((Object)"Using Application server TM component", new Object[0]);
            return;
        }
        try {
            this.jotm = new Jotm(true, false);
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot init JOTM object", (Throwable)e);
        }
        try {
            this.jotm.getTransactionManager().setTransactionTimeout(this.timeout);
        }
        catch (SystemException se) {
            throw new EZBComponentException("Cannot set Transaction Timeout", (Throwable)se);
        }
        try {
            new InitialContext().rebind("javax.transaction.UserTransaction", (Object)this.jotm.getTransactionManager());
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot bind user transaction", (Throwable)e);
        }
        JTransactionManager.init();
        logger.info((Object)"Register {0} as transaction manager object", new Object[]{"javax.transaction.UserTransaction"});
    }

    public void stop() throws EZBComponentException {
        try {
            new InitialContext().unbind("javax.transaction.UserTransaction");
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot unbind user transaction", (Throwable)e);
        }
        TimerManager.stop((boolean)true);
        this.jotm.stop();
        logger.info((Object)"JOTM Component stopped", new Object[0]);
    }

    public TransactionManager getTransactionManager() {
        if (this.jotm != null) {
            return this.jotm.getTransactionManager();
        }
        return this.tm;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public XATerminator getXATerminator() throws XAException {
        return ((Current)this.getTransactionManager()).getXATerminator();
    }

    public void begin(Xid xid) throws NotSupportedException, SystemException {
        ((Current)this.getTransactionManager()).begin(xid);
    }

    public void begin(Xid xid, long timeout) throws NotSupportedException, SystemException {
        ((Current)this.getTransactionManager()).begin(xid, timeout);
    }

    public void clearThreadTx() {
        ((Current)this.getTransactionManager()).clearThreadTx();
    }
}

