/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.mail.factory;

import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.ow2.easybeans.component.mail.factory.AbsJavaMailFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMailMimePartDataSourceFactory
extends AbsJavaMailFactory
implements ObjectFactory {
    public static final String FACTORY_TYPE = "javax.mail.internet.MimePartDataSource";
    public static final String TO_RECIPIENTS = "to.recipients";
    public static final String CC_RECIPIENTS = "cc.recipients";
    public static final String BCC_RECIPIENTS = "bcc.recipients";
    public static final String SUBJECT = "subject";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        String mailSubject;
        Address[] bccRecipients;
        Address[] ccRecipients;
        Reference reference = (Reference)obj;
        if (!FACTORY_TYPE.equals(reference.getClassName())) {
            return null;
        }
        MimeMessage mimeMessage = new MimeMessage(Session.getInstance((Properties)this.getSessionProperties(reference), (Authenticator)this.getAuthenticator(reference)));
        Address[] toRecipients = (Address[])this.getObject(reference, TO_RECIPIENTS);
        if (toRecipients != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, toRecipients);
        }
        if ((ccRecipients = (Address[])this.getObject(reference, CC_RECIPIENTS)) != null) {
            mimeMessage.setRecipients(Message.RecipientType.CC, ccRecipients);
        }
        if ((bccRecipients = (Address[])this.getObject(reference, BCC_RECIPIENTS)) != null) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, bccRecipients);
        }
        if ((mailSubject = this.getString(reference, SUBJECT)) != null) {
            mimeMessage.setSubject(mailSubject);
        }
        MimePartDataSource mimePartDS = new MimePartDataSource((MimePart)mimeMessage);
        return mimePartDS;
    }
}

