/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetail;
import org.ow2.easybeans.component.quartz.EasyBeansTimerHandle;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansTimer
implements Timer {
    private EasyBeansJobDetail jobDetail = null;
    private Trigger trigger = null;
    private Scheduler scheduler = null;
    private Factory<?, ?> factory = null;

    public EasyBeansTimer(EasyBeansJobDetail jobDetail, Trigger trigger, Scheduler scheduler, Factory<?, ?> factory) {
        this.jobDetail = jobDetail;
        this.trigger = trigger;
        this.scheduler = scheduler;
        this.factory = factory;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The cancel() method cannot be called within the operation state '" + operationState + "'.");
        }
        try {
            this.scheduler.deleteJob(this.jobDetail.getName(), this.jobDetail.getGroup());
        }
        catch (SchedulerException e) {
            throw new EJBException("Cannot cancel job with name '" + this.jobDetail.getName() + "'.", (Exception)((Object)e));
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getTimeRemaining() method cannot be called within the operation state '" + operationState + "'.");
        }
        return this.getNextTimeout().getTime() - System.currentTimeMillis();
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getNextTimeout() method cannot be called within the operation state '" + operationState + "'.");
        }
        Date date = this.trigger.getNextFireTime();
        if (date == null) {
            throw new IllegalStateException("No next timeout for this timer");
        }
        return date;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getInfo() method cannot be called within the operation state '" + operationState + "'.");
        }
        return this.jobDetail.getJobDetailData().getInfo();
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getHandle() method cannot be called within the operation state '" + operationState + "'.");
        }
        return new EasyBeansTimerHandle(this.jobDetail);
    }
}

