/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.EmbeddedManager;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.components.EZBComponentRegistry;
import org.ow2.easybeans.component.itf.TimerComponent;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetail;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetailData;
import org.ow2.easybeans.component.quartz.EasyBeansTimer;
import org.ow2.easybeans.component.quartz.QuartzComponent;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class EasyBeansTimerHandle
implements TimerHandle {
    private static final long serialVersionUID = 5391559452078385341L;
    private EasyBeansJobDetail easyBeansJobDetail;

    public EasyBeansTimerHandle(EasyBeansJobDetail easyBeansJobDetail) {
        this.easyBeansJobDetail = easyBeansJobDetail;
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        EasyBeansTimer timer = null;
        String jobName = this.easyBeansJobDetail.getName();
        String groupName = this.easyBeansJobDetail.getGroup();
        EasyBeansJobDetailData easyBeansJobDetailData = this.easyBeansJobDetail.getJobDetailData();
        Integer easyBeansServerID = easyBeansJobDetailData.getEasyBeansServerID();
        String containerID = easyBeansJobDetailData.getContainerId();
        String factoryName = easyBeansJobDetailData.getFactoryName();
        EZBServer embedded = EmbeddedManager.getEmbedded((Integer)easyBeansServerID);
        EZBContainer container = embedded.getContainer(containerID);
        Factory factory = container.getFactory(factoryName);
        OperationState operationState = factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getTimer() method cannot be called within the operation state '" + operationState + "'.");
        }
        EZBComponentRegistry registry = embedded.getComponentManager().getComponentRegistry();
        List timerComponents = registry.getComponents(TimerComponent.class);
        if (timerComponents == null || timerComponents.size() == 0) {
            throw new EJBException("Cannot get the timer object as no timer component have been found on the EasyBeans server");
        }
        TimerComponent timerComponent = (TimerComponent)timerComponents.get(0);
        QuartzComponent quartzComponent = null;
        if (!(timerComponent instanceof QuartzComponent)) {
            throw new EJBException("The timer component found is not a Quartz Timer Component ('" + timerComponent + "').");
        }
        quartzComponent = (QuartzComponent)timerComponent;
        Scheduler scheduler = quartzComponent.getScheduler();
        JobDetail jobDetail = null;
        try {
            jobDetail = scheduler.getJobDetail(jobName, groupName);
        }
        catch (SchedulerException e) {
            throw new EJBException("Cannot get the jobDetail for the jobName '" + jobName + "'.", (Exception)((Object)e));
        }
        EasyBeansJobDetail easyBeansJobDetail = null;
        if (!(jobDetail instanceof EasyBeansJobDetail)) {
            throw new EJBException("JobDetail found for the job named '" + jobName + "' is not an EasyBeansJobDetail object");
        }
        easyBeansJobDetail = (EasyBeansJobDetail)jobDetail;
        Trigger[] triggers = null;
        try {
            triggers = scheduler.getTriggersOfJob(jobName, groupName);
        }
        catch (SchedulerException e) {
            throw new EJBException("Cannot get triggers for the job named '" + jobName + "'.", (Exception)((Object)e));
        }
        if (triggers == null || triggers.length > 1) {
            throw new EJBException("Invalid numbers of triggers found for the job named '" + jobName + "'.");
        }
        timer = new EasyBeansTimer(easyBeansJobDetail, triggers[0], scheduler, factory);
        return timer;
    }
}

