/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session;

import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;
import org.ow2.util.pool.impl.enhanced.api.basic.CreatePoolItemException;
import org.ow2.util.pool.impl.enhanced.api.clue.basiccluemanager.IClueAccessor;
import org.ow2.util.pool.impl.enhanced.manager.optional.IPoolItemRemoveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPoolWrapperFactory<InstanceType, Clue>
implements PoolFactory<InstanceType, Clue> {
    private IPoolItemRemoveManager<InstanceType> factory;
    private IClueAccessor<InstanceType, Clue> clueFactory;

    public JPoolWrapperFactory(IPoolItemRemoveManager<InstanceType> factory) {
        this(factory, null);
    }

    public JPoolWrapperFactory(IPoolItemRemoveManager<InstanceType> factory, IClueAccessor<InstanceType, Clue> clueFactory) {
        this.factory = factory;
        this.clueFactory = clueFactory;
    }

    public InstanceType create(Clue clue) throws PoolException {
        Object instance = null;
        try {
            instance = this.factory.createPoolItem();
        }
        catch (CreatePoolItemException e) {
            throw new PoolException("Cannot create item", (Throwable)e);
        }
        if (this.clueFactory != null) {
            this.clueFactory.setClue(instance, clue);
        }
        return (InstanceType)instance;
    }

    public boolean isMatching(InstanceType instance, Clue clue) {
        if (this.clueFactory == null) {
            return true;
        }
        if (clue == null) {
            return true;
        }
        return clue.equals(this.clueFactory.getClue(instance));
    }

    public void remove(InstanceType instance) {
        this.factory.poolItemRemoved(instance);
    }

    public boolean validate(InstanceType instance, PoolEntryStatistics stats) {
        return true;
    }
}

