/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean.mdb;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.List;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.helper.ResolverHelper;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJMessageDriven;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JMessageDriven;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class MDBBeanHelper {
    private static final String MDB_METHODS = "ejbCreate()/ejbRemove() methods";
    private static Log logger = LogFactory.getLog(MDBBeanHelper.class);
    private static final JMethod EJBCREATE_METHOD = new JMethod(1, "ejbCreate", "()V", null, new String[]{"javax/ejb/CreateException"});
    private static final JMethod EJBREMOVE_METHOD = new JMethod(1, "ejbRemove", "()V", null, new String[]{"javax/ejb/EJBException", "java/rmi/RemoteException"});

    private MDBBeanHelper() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata mdbBean) throws ResolverException {
        IJMessageDriven jMessageDriven;
        EasyBeansEjbJarMethodMetadata ejbRemoveMethod;
        EasyBeansEjbJarMethodMetadata ejbCreateMethod = ResolverHelper.getMethod(mdbBean, EJBCREATE_METHOD, true, MDB_METHODS, false);
        if (ejbCreateMethod != null) {
            ejbCreateMethod.setPostConstruct(true);
            if (!mdbBean.getPostConstructMethodsMetadata().contains(ejbCreateMethod)) {
                mdbBean.addPostConstructMethodMetadata(ejbCreateMethod);
            }
        }
        if ((ejbRemoveMethod = ResolverHelper.getMethod(mdbBean, EJBREMOVE_METHOD, true, MDB_METHODS, false)) != null) {
            ejbRemoveMethod.setPreDestroy(true);
            if (!mdbBean.getPreDestroyMethodsMetadata().contains(ejbRemoveMethod)) {
                mdbBean.addPreDestroyMethodMetadata(ejbRemoveMethod);
            }
        }
        if ((jMessageDriven = mdbBean.getJMessageDriven()) == null) {
            jMessageDriven = new JMessageDriven();
        }
        if (jMessageDriven.getMessageListenerInterface() != null) {
            return;
        }
        String[] interfaces = mdbBean.getInterfaces();
        List inheritedInterfaces = mdbBean.getInheritedInterfaces();
        int numberItfFound = 0;
        String itfFound = null;
        for (String itf : interfaces) {
            if (itf.equals(Serializable.class.getName().replace(".", "/")) || itf.equals(Externalizable.class.getName().replace(".", "/")) || itf.startsWith("javax/ejb") || inheritedInterfaces.contains(itf)) continue;
            itfFound = itf;
            ++numberItfFound;
        }
        if (numberItfFound == 0 && inheritedInterfaces != null && inheritedInterfaces.size() == 1) {
            itfFound = (String)inheritedInterfaces.get(0);
            numberItfFound = 1;
        }
        if (numberItfFound == 0) {
            throw new IllegalStateException("No message listener interface has been found on bean class '" + mdbBean.getClassName() + "' It needs to be specified with annotation or XML.");
        }
        if (numberItfFound > 1) {
            throw new IllegalStateException("More than 1 message listener interface on the class '" + mdbBean.getClassName() + "' The message listener interface needs to be specified with annotation or XML..");
        }
        jMessageDriven.setMessageListenerInterface(itfFound.replace("/", "."));
    }
}

