/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IJClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.InterceptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInterceptorsBuilder {
    private List<IJClassInterceptor> allInterceptors = null;
    private EasyBeansEjbJarMethodMetadata methodAnnotationMetadata;
    private EasyBeansEjbJarClassMetadata classAnnotationMetadata = null;
    private InterceptorType interceptorType = null;

    public MethodInterceptorsBuilder(EasyBeansEjbJarMethodMetadata methodAnnotationMetadata, InterceptorType interceptorType) {
        this.methodAnnotationMetadata = methodAnnotationMetadata;
        this.interceptorType = interceptorType;
        this.classAnnotationMetadata = (EasyBeansEjbJarClassMetadata)methodAnnotationMetadata.getClassMetadata();
        this.buildInterceptorList();
    }

    public List<IJClassInterceptor> getAllInterceptors() {
        return this.allInterceptors;
    }

    private void buildInterceptorList() {
        List userInterceptorslist;
        List defaultInterceptorslist;
        this.allInterceptors = new ArrayList<IJClassInterceptor>();
        if (this.classAnnotationMetadata.getGlobalEasyBeansInterceptors() != null) {
            for (IJClassInterceptor interceptor : this.classAnnotationMetadata.getGlobalEasyBeansInterceptors()) {
                this.allInterceptors.add(interceptor);
            }
        }
        if (this.methodAnnotationMetadata.getGlobalEasyBeansInterceptors() != null) {
            for (IJClassInterceptor interceptor : this.methodAnnotationMetadata.getGlobalEasyBeansInterceptors()) {
                this.allInterceptors.add(interceptor);
            }
        }
        if (this.methodAnnotationMetadata.getInterceptors() != null) {
            for (IJClassInterceptor interceptor : this.methodAnnotationMetadata.getInterceptors()) {
                this.allInterceptors.add(interceptor);
            }
        }
        EjbJarArchiveMetadata ejbJarAnnotationMetadata = (EjbJarArchiveMetadata)this.classAnnotationMetadata.getEjbJarDeployableMetadata();
        if (!(this.classAnnotationMetadata.isOrderedInterceptors() || ejbJarAnnotationMetadata.getDefaultInterceptors() == null || this.classAnnotationMetadata.isExcludedDefaultInterceptors() || this.methodAnnotationMetadata.isExcludedDefaultInterceptors() || (defaultInterceptorslist = (List)ejbJarAnnotationMetadata.getDefaultInterceptors().get(this.interceptorType)) == null)) {
            for (IJClassInterceptor interceptor : defaultInterceptorslist) {
                this.allInterceptors.add(interceptor);
            }
        }
        if (this.classAnnotationMetadata.getExternalUserEasyBeansInterceptors() != null && !this.methodAnnotationMetadata.isExcludedClassInterceptors() && (userInterceptorslist = (List)this.classAnnotationMetadata.getExternalUserEasyBeansInterceptors().get(this.interceptorType)) != null) {
            for (IJClassInterceptor interceptor : userInterceptorslist) {
                this.allInterceptors.add(interceptor);
            }
        }
        if (this.methodAnnotationMetadata.getUserEasyBeansInterceptors() != null && (userInterceptorslist = (List)this.methodAnnotationMetadata.getUserEasyBeansInterceptors().get(this.interceptorType)) != null) {
            for (IJClassInterceptor interceptor : userInterceptorslist) {
                this.allInterceptors.add(interceptor);
            }
        }
        if (this.classAnnotationMetadata.getInternalUserEasyBeansInterceptors() != null && !this.methodAnnotationMetadata.isExcludedClassInterceptors() && (userInterceptorslist = (List)this.classAnnotationMetadata.getInternalUserEasyBeansInterceptors().get(this.interceptorType)) != null) {
            this.allInterceptors.addAll(userInterceptorslist);
        }
    }
}

