/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming.interceptors;

import java.lang.reflect.Method;
import javax.naming.Context;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.naming.NamingInterceptor;
import org.ow2.easybeans.naming.interceptors.AbsENCInterceptor;

public class Jetty6ENCInterceptor
extends AbsENCInterceptor
implements NamingInterceptor {
    protected static final String JETTY_CONTEXT_FACTORY_CLASS = "org.mortbay.naming.ContextFactory";
    private static Method setComponentContextMethod = null;
    private static Method resetComponentContextMethod = null;

    public Jetty6ENCInterceptor() {
        if (setComponentContextMethod == null || resetComponentContextMethod == null) {
            String errMsg = "Check that EasyBeans is embedded in Jetty server.";
            Class<?> namingClass = null;
            try {
                namingClass = Thread.currentThread().getContextClassLoader().loadClass(JETTY_CONTEXT_FACTORY_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load the Jetty context factory class 'org.mortbay.naming.ContextFactory'. " + errMsg, e);
            }
            try {
                setComponentContextMethod = namingClass.getMethod("setComponentContext", Context.class);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get setComponentContext(Context) method on the JOnAS naming manager class 'org.mortbay.naming.ContextFactory'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get setComponentContext(Context) method on the JOnAS naming manager class 'org.mortbay.naming.ContextFactory'. " + errMsg, e);
            }
            try {
                resetComponentContextMethod = namingClass.getMethod("resetComponentContext", Context.class);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get resetComponentContext(Context) method on the JOnAS naming manager class 'org.mortbay.naming.ContextFactory'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get resetComponentContext(Context) method on the JOnAS naming manager class 'org.mortbay.naming.ContextFactory'. " + errMsg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        Object object;
        Context oldContext = (Context)setComponentContextMethod.invoke(null, invocationContext.getFactory().getJavaContext().lookup("comp"));
        try {
            object = invocationContext.proceed();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            resetComponentContextMethod.invoke(null, oldContext);
            throw throwable;
        }
        resetComponentContextMethod.invoke(null, oldContext);
        return object;
    }
}

