/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.easybeans.transaction.JTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerManagedEntityManager
implements EntityManager {
    private EntityManager wrappedEntityManager = null;

    public ContainerManagedEntityManager(EntityManager entityManager) {
        this.wrappedEntityManager = entityManager;
    }

    public void persist(Object entity) throws IllegalArgumentException, TransactionRequiredException {
        this.checkTransaction();
        this.wrappedEntityManager.persist(entity);
    }

    public <T> T merge(T entity) throws IllegalArgumentException, TransactionRequiredException {
        this.checkTransaction();
        return (T)this.wrappedEntityManager.merge(entity);
    }

    public void remove(Object entity) throws IllegalArgumentException, TransactionRequiredException {
        this.checkTransaction();
        this.wrappedEntityManager.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) throws IllegalArgumentException {
        return (T)this.wrappedEntityManager.find(entityClass, primaryKey);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) throws IllegalArgumentException, EntityNotFoundException {
        return (T)this.wrappedEntityManager.getReference(entityClass, primaryKey);
    }

    public void flush() throws TransactionRequiredException, PersistenceException {
        this.wrappedEntityManager.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.wrappedEntityManager.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.wrappedEntityManager.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) throws PersistenceException, IllegalArgumentException, TransactionRequiredException {
        this.wrappedEntityManager.lock(entity, lockMode);
    }

    public void refresh(Object entity) throws IllegalArgumentException, TransactionRequiredException, EntityNotFoundException {
        this.checkTransaction();
        this.wrappedEntityManager.refresh(entity);
    }

    public void clear() {
        this.wrappedEntityManager.clear();
    }

    public boolean contains(Object entity) throws IllegalArgumentException {
        return this.wrappedEntityManager.contains(entity);
    }

    public Query createQuery(String ejbqlString) throws IllegalArgumentException {
        return this.wrappedEntityManager.createQuery(ejbqlString);
    }

    public Query createNamedQuery(String name) throws IllegalArgumentException {
        return this.wrappedEntityManager.createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString) {
        return this.wrappedEntityManager.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.wrappedEntityManager.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.wrappedEntityManager.createNativeQuery(sqlString, resultSetMapping);
    }

    public void joinTransaction() throws IllegalStateException, TransactionRequiredException {
        this.wrappedEntityManager.joinTransaction();
    }

    public Object getDelegate() throws IllegalStateException {
        return this.wrappedEntityManager.getDelegate();
    }

    public void close() throws IllegalStateException {
        throw new IllegalStateException("This entity manager is a container managed entity manager. This operation is denied.");
    }

    public boolean isOpen() {
        return this.wrappedEntityManager.isOpen();
    }

    public EntityTransaction getTransaction() throws IllegalStateException {
        return this.wrappedEntityManager.getTransaction();
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) throws IllegalArgumentException {
        return this.wrappedEntityManager.createNamedQuery(name, resultClass);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) throws IllegalArgumentException {
        return this.wrappedEntityManager.createQuery(criteriaQuery);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) throws IllegalArgumentException {
        return this.wrappedEntityManager.createQuery(qlString, resultClass);
    }

    public void detach(Object entity) throws IllegalArgumentException {
        this.wrappedEntityManager.detach(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) throws IllegalArgumentException {
        return (T)this.wrappedEntityManager.find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) throws IllegalArgumentException, TransactionRequiredException, OptimisticLockException, PessimisticLockException, LockTimeoutException, PersistenceException {
        return (T)this.wrappedEntityManager.find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) throws IllegalArgumentException, TransactionRequiredException, OptimisticLockException, PessimisticLockException, LockTimeoutException, PersistenceException {
        return (T)this.wrappedEntityManager.find(entityClass, primaryKey, lockMode, properties);
    }

    public CriteriaBuilder getCriteriaBuilder() throws IllegalStateException {
        return this.wrappedEntityManager.getCriteriaBuilder();
    }

    public EntityManagerFactory getEntityManagerFactory() throws IllegalStateException {
        return this.wrappedEntityManager.getEntityManagerFactory();
    }

    public LockModeType getLockMode(Object entity) throws TransactionRequiredException, IllegalArgumentException {
        return this.wrappedEntityManager.getLockMode(entity);
    }

    public Metamodel getMetamodel() throws IllegalStateException {
        return this.wrappedEntityManager.getMetamodel();
    }

    public Map<String, Object> getProperties() {
        return this.wrappedEntityManager.getProperties();
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) throws IllegalArgumentException, TransactionRequiredException, EntityNotFoundException, OptimisticLockException, PessimisticLockException, LockTimeoutException, PersistenceException {
        this.wrappedEntityManager.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity, Map<String, Object> properties) throws IllegalArgumentException, TransactionRequiredException, EntityNotFoundException {
        this.wrappedEntityManager.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) throws IllegalArgumentException, TransactionRequiredException, EntityNotFoundException, PessimisticLockException, LockTimeoutException, PersistenceException {
        this.wrappedEntityManager.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) throws IllegalArgumentException, TransactionRequiredException, EntityNotFoundException, PessimisticLockException, LockTimeoutException, PersistenceException {
        this.wrappedEntityManager.refresh(entity, lockMode, properties);
    }

    public void setProperty(String propertyName, Object value) throws IllegalArgumentException {
        this.wrappedEntityManager.setProperty(propertyName, value);
    }

    public <T> T unwrap(Class<T> cls) throws PersistenceException {
        return (T)this.wrappedEntityManager.unwrap(cls);
    }

    protected void checkTransaction() throws TransactionRequiredException {
        Transaction currentTx = null;
        try {
            currentTx = JTransactionManager.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot get current transaction", e);
        }
        if (currentTx == null) {
            throw new TransactionRequiredException("The operation needs to be executed within a transaction");
        }
    }
}

