/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence.xml;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfo;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfoException;
import org.ow2.easybeans.persistence.xml.PersistenceUnitEntityResolver;
import org.ow2.easybeans.util.xml.DocumentParser;
import org.ow2.easybeans.util.xml.DocumentParserException;
import org.ow2.easybeans.util.xml.XMLUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPersistenceUnitInfoLoader {
    private static final String PERSISTENCE_NS = "http://java.sun.com/xml/ns/persistence";
    private static final String PERSISTENCE_UNIT = "persistence-unit";
    private static final String PERSISTENCE_FILE_PATH = "/META-INF/persistence.xml";
    private static Log logger = LogFactory.getLog(JPersistenceUnitInfoLoader.class);
    private static boolean validating = true;

    private JPersistenceUnitInfoLoader() {
    }

    public static List<JPersistenceUnitInfo> loadPersistenceUnitInfoImplList(URL url) throws JPersistenceUnitInfoException {
        logger.debug((Object)"Analyzing url {0}", new Object[]{url});
        ArrayList<JPersistenceUnitInfo> jPersistenceUnitInfos = new ArrayList<JPersistenceUnitInfo>();
        Document document = null;
        try {
            document = DocumentParser.getDocument((URL)url, (boolean)validating, (EntityResolver)((Object)new PersistenceUnitEntityResolver()));
        }
        catch (DocumentParserException e) {
            throw new JPersistenceUnitInfoException("Cannot parse the url", e);
        }
        Element persistenceRootElement = document.getDocumentElement();
        String version = XMLUtils.getAttributeValue((Element)persistenceRootElement, (String)"version");
        NodeList persistenceUnitInfoList = persistenceRootElement.getElementsByTagNameNS(PERSISTENCE_NS, PERSISTENCE_UNIT);
        for (int i = 0; i < persistenceUnitInfoList.getLength(); ++i) {
            Element pUnitElement = (Element)persistenceUnitInfoList.item(i);
            JPersistenceUnitInfo persistenceUnitInfo = new JPersistenceUnitInfo();
            persistenceUnitInfo.setPersistenceXmlFileUrl(url);
            persistenceUnitInfo.setPersistenceXMLSchemaVersion(version);
            String className = XMLUtils.getStringValueElement((String)PERSISTENCE_NS, (Element)pUnitElement, (String)"provider");
            persistenceUnitInfo.setPersistenceProviderClassName(className);
            String jtaDataSourceName = XMLUtils.getStringValueElement((String)PERSISTENCE_NS, (Element)pUnitElement, (String)"jta-data-source");
            persistenceUnitInfo.setJtaDataSourceName(jtaDataSourceName);
            String nonJtaDataSourceName = XMLUtils.getStringValueElement((String)PERSISTENCE_NS, (Element)pUnitElement, (String)"non-jta-data-source");
            persistenceUnitInfo.setNonJtaDataSourceName(nonJtaDataSourceName);
            List mappingFiles = XMLUtils.getStringListValueElement((String)PERSISTENCE_NS, (Element)pUnitElement, (String)"mapping-file");
            for (String mappingFileName : mappingFiles) {
                persistenceUnitInfo.addMappingFileName(mappingFileName);
            }
            List jarFiles = XMLUtils.getStringListValueElement((String)PERSISTENCE_NS, (Element)pUnitElement, (String)"jar-file");
            for (String jarFileName : jarFiles) {
                try {
                    String persistencePath = url.getPath();
                    int index = persistencePath.indexOf(PERSISTENCE_FILE_PATH);
                    int index1 = persistencePath.substring(0, index).lastIndexOf(47);
                    String basePath = persistencePath.substring(0, index1 + 1);
                    String jarPath = basePath.concat(jarFileName);
                    logger.debug((Object)"Got a JAR path {0}.", new Object[]{jarPath});
                    URL jarUrl = new URL(jarPath);
                    File jarFile = new File(jarUrl.getPath());
                    if (jarFile != null && jarFile.exists()) {
                        persistenceUnitInfo.addJarFile(jarUrl);
                        continue;
                    }
                    logger.warn((Object)">> Found an inexistent JAR declaration {0}.", new Object[]{jarPath});
                }
                catch (MalformedURLException me) {
                    logger.error((Object)"Got MalformedURLException {0}", new Object[]{me});
                    throw new JPersistenceUnitInfoException("Problem with jar-file " + jarFileName);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.error((Object)"Got IndexOutOfBoundsException {0}", new Object[]{e});
                    throw new JPersistenceUnitInfoException("Problem with jar-file " + jarFileName);
                }
            }
            List classes = XMLUtils.getStringListValueElement((String)PERSISTENCE_NS, (Element)pUnitElement, (String)"class");
            for (String managedClassName : classes) {
                persistenceUnitInfo.addClass(managedClassName);
            }
            String excluded = XMLUtils.getStringValueElement((String)PERSISTENCE_NS, (Element)pUnitElement, (String)"exclude-unlisted-classes");
            persistenceUnitInfo.setExcludeUnlistedClasses("true".equals(excluded));
            Properties props = XMLUtils.getPropertiesValueElement((String)PERSISTENCE_NS, (Element)pUnitElement, (String)"properties");
            persistenceUnitInfo.setProperties(props);
            String name = XMLUtils.getAttributeValue((Element)pUnitElement, (String)"name");
            persistenceUnitInfo.setPersistenceUnitName(name);
            String transactionType = XMLUtils.getAttributeValue((Element)pUnitElement, (String)"transaction-type");
            if ("JTA".equals(transactionType)) {
                persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.JTA);
            } else if ("RESOURCE_LOCAL".equals(transactionType)) {
                persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
            } else {
                logger.warn((Object)"No transaction-type defined. Set to default JTA transaction-type", new Object[0]);
                persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.JTA);
            }
            if ("2.0".equals(version)) {
                String sharedCacheMode = XMLUtils.getAttributeValue((Element)pUnitElement, (String)"shared-cache-mode");
                if ("ALL".equals(sharedCacheMode)) {
                    persistenceUnitInfo.setSharedCacheMode(SharedCacheMode.ALL);
                } else if ("NONE".equals(sharedCacheMode)) {
                    persistenceUnitInfo.setSharedCacheMode(SharedCacheMode.NONE);
                } else if ("ENABLE_SELECTIVE".equals(sharedCacheMode)) {
                    persistenceUnitInfo.setSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
                } else if ("DISABLE_SELECTIVE".equals(sharedCacheMode)) {
                    persistenceUnitInfo.setSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
                } else if ("UNSPECIFIED".equals(sharedCacheMode)) {
                    persistenceUnitInfo.setSharedCacheMode(SharedCacheMode.UNSPECIFIED);
                } else {
                    logger.warn((Object)"No SharedCacheMode defined. Set to default UNSPECIFIED", new Object[0]);
                    persistenceUnitInfo.setSharedCacheMode(SharedCacheMode.UNSPECIFIED);
                }
                String validationMode = XMLUtils.getAttributeValue((Element)pUnitElement, (String)"validation-mode");
                if ("AUTO".equals(validationMode)) {
                    persistenceUnitInfo.setValidationMode(ValidationMode.AUTO);
                } else if ("CALLBACK".equals(sharedCacheMode)) {
                    persistenceUnitInfo.setValidationMode(ValidationMode.CALLBACK);
                } else if ("NONE".equals(sharedCacheMode)) {
                    persistenceUnitInfo.setValidationMode(ValidationMode.NONE);
                } else {
                    logger.warn((Object)"No Validation Mode defined. Set to default AUTO", new Object[0]);
                    persistenceUnitInfo.setValidationMode(ValidationMode.AUTO);
                }
            }
            jPersistenceUnitInfos.add(persistenceUnitInfo);
        }
        return jPersistenceUnitInfos;
    }

    public static JPersistenceUnitInfo[] loadPersistenceUnitInfoImpl(URL url) throws JPersistenceUnitInfoException {
        List<JPersistenceUnitInfo> jPersistenceUnitInfos = JPersistenceUnitInfoLoader.loadPersistenceUnitInfoImplList(url);
        return jPersistenceUnitInfos.toArray(new JPersistenceUnitInfo[jPersistenceUnitInfos.size()]);
    }
}

