/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.Handle;
import javax.ejb.NoSuchEJBException;
import javax.ejb.TransactionRequiredLocalException;
import javax.transaction.TransactionRequiredException;
import org.ow2.easybeans.container.svc.EasyBeansHandle;
import org.ow2.easybeans.proxy.client.AbsInvocationHandler;
import org.ow2.easybeans.rpc.EJBRemoteRequestImpl;
import org.ow2.easybeans.rpc.RPC;
import org.ow2.easybeans.rpc.api.ClientRPC;
import org.ow2.easybeans.rpc.api.EJBRemoteRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.easybeans.rpc.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRPCInvocationHandler
extends AbsInvocationHandler {
    private static final long serialVersionUID = 1852625501781836250L;
    private static final boolean RECREATE_DYNAMIC_PROXY = Boolean.getBoolean("easybeans.recreate.dynamic.proxy");
    private Hashtable<?, ?> rmiClientEnvironment = null;

    public ClientRPCInvocationHandler(String containerId, String factoryName, boolean useID) {
        super(containerId, factoryName, useID);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        return this.invoke(proxy, method, args, null, null);
    }

    protected Object invoke(Object proxy, Method method, Object[] args, String methodName, Long hashMethod) throws Exception {
        ClientRPCInvocationHandler invocationHandler;
        Object value;
        EJBResponse response;
        if (this.isRemoved()) {
            this.handleThrowable(this.convertThrowable((Throwable)new NoSuchEJBException("The bean has been removed")), false, method, null);
        }
        if (!(!method.getDeclaringClass().getName().equals("java.lang.Object") || this.isUsingID() && this.getBeanId() == null && method.getName().equals("toString"))) {
            return this.handleObjectMethods(method, args);
        }
        if ("getHandle".equals(method.getName()) && Handle.class.equals(method.getReturnType())) {
            return new EasyBeansHandle((EJBObject)proxy);
        }
        ClientRPC client = RPC.getClient(this.rmiClientEnvironment);
        if (this.getHashedMethods() == null) {
            this.setHashedMethods(new HashMap<Method, Long>());
        }
        Long hashLong = null;
        if (hashMethod == null) {
            hashLong = this.getHashedMethods().get(method);
            if (hashLong == null) {
                hashLong = Hash.hashMethod(method);
                this.getHashedMethods().put(method, hashLong);
            }
        } else {
            hashLong = hashMethod;
        }
        String mName = null;
        mName = methodName != null ? methodName : method.getName();
        EJBRemoteRequestImpl request = new EJBRemoteRequestImpl(mName, hashLong, args, this.getContainerId(), this.getFactoryName(), this.getBeanId(), this.getInterfaceClassName());
        try {
            response = client.sendEJBRequest((EJBRemoteRequest)request);
        }
        catch (RuntimeException e) {
            throw new EJBException("Error while sending a request", (Exception)e);
        }
        this.setBeanId(response.getBeanId());
        if (method.getDeclaringClass().getName().equals("java.lang.Object") && this.getBeanId() != null && method.getName().equals("toString")) {
            return this.handleObjectMethods(method, args);
        }
        this.setRemoved(response.isRemoved());
        RPCException rpcException = response.getRPCException();
        if (rpcException != null) {
            this.handleThrowable(this.convertThrowable(rpcException.getCause()), rpcException.isApplicationException(), method, rpcException);
        }
        if (RECREATE_DYNAMIC_PROXY && (value = response.getValue()) != null && value instanceof ClientRPCInvocationHandler && (invocationHandler = (ClientRPCInvocationHandler)value).isBusinessObjectMode()) {
            Class<?> interfaceClass = Thread.currentThread().getContextClassLoader().loadClass(invocationHandler.getInterfaceClassName());
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)invocationHandler);
        }
        return response.getValue();
    }

    protected Throwable convertThrowable(Throwable throwable) {
        if (this.isExtendingRmiRemote() && throwable instanceof NoSuchEJBException) {
            NoSuchObjectException ne = new NoSuchObjectException(throwable.getMessage());
            ne.detail = throwable;
            return ne;
        }
        if (throwable instanceof TransactionRequiredLocalException) {
            if (this.isExtendingRmiRemote()) {
                TransactionRequiredException tre = new TransactionRequiredException(throwable.getMessage());
                tre.detail = throwable;
                return tre;
            }
            EJBTransactionRequiredException ejbTransRequiredException = new EJBTransactionRequiredException(throwable.getMessage());
            ejbTransRequiredException.initCause(throwable);
            return ejbTransRequiredException;
        }
        return throwable;
    }

    public void setRMIEnv(Hashtable<?, ?> rmiClientEnvironment) {
        this.rmiClientEnvironment = rmiClientEnvironment;
    }

    public Hashtable<?, ?> getRMIEnv() {
        return this.rmiClientEnvironment;
    }
}

