/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.container.svc.EasyBeansMetaData;
import org.ow2.easybeans.proxy.client.ClientRPCInvocationHandler;
import org.ow2.easybeans.rpc.util.Hash;

public class EJBHomeRPCInvocationHandler
extends ClientRPCInvocationHandler {
    private static final long serialVersionUID = -5766859656696754086L;
    private String remoteInterface = null;

    public EJBHomeRPCInvocationHandler(String containerId, String factoryName, boolean useID, String remoteInterface) {
        super(containerId, factoryName, useID);
        this.remoteInterface = remoteInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        if (method == null) return super.invoke(proxy, method, args);
        if (method.getName().startsWith("create")) {
            Class<?> itfClass = method.getReturnType();
            ClientRPCInvocationHandler handler = new ClientRPCInvocationHandler(this.getContainerId(), this.getFactoryName(), this.isUsingID());
            handler.setRMIEnv(this.getRMIEnv());
            handler.setInterfaceClass(itfClass);
            handler.setInterfaceClassName(null);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Object beanProxy = Proxy.newProxyInstance(classLoader, new Class[]{itfClass}, (InvocationHandler)handler);
            beanProxy.toString();
            Long beanId = this.getBeanId();
            try {
                try {
                    Class<?> ejbHomeClass = classLoader.loadClass(this.getInterfaceClassName());
                    Method ejbCreateMethod = ejbHomeClass.getMethod("create", method.getParameterTypes());
                    Type[] argumentTypes = Type.getArgumentTypes((Method)ejbCreateMethod);
                    String methodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])argumentTypes);
                    long hashCode = Hash.hashMethod("ejbCreate", methodDescriptor);
                    this.setBeanId(handler.getBeanId());
                    super.invoke(beanProxy, ejbCreateMethod, args, "ejbCreate", hashCode);
                }
                catch (NoSuchMethodException e) {
                    Object var16_16 = null;
                    this.setBeanId(beanId);
                    return beanProxy;
                }
                Object var16_15 = null;
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                this.setBeanId(beanId);
                throw throwable;
            }
            this.setBeanId(beanId);
            return beanProxy;
        }
        if (method.getName().equals("remove")) {
            this.handleRemoveMethod(args);
            return null;
        }
        if (method.getName().equals("getEJBMetaData")) {
            return this.handleGetEJBMetadata(proxy);
        }
        if (!method.getName().equals("getHomeHandle")) return super.invoke(proxy, method, args);
        return this.handleGetHomeHandle();
    }

    private void handleRemoveMethod(Object[] args) throws RemoteException, RemoveException {
        if (!(args[0] instanceof Handle)) {
            throw new RemoveException("The remove method is not allowed with an object which is not an handle.Primary key is only used for entity 2.1x bean.");
        }
        Handle handle = (Handle)args[0];
        EJBObject ejbObject = handle.getEJBObject();
        ejbObject.remove();
    }

    private EJBMetaData handleGetEJBMetadata(Object proxy) throws RemoteException {
        EJBHome ejbHome = (EJBHome)proxy;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> homeInterfaceClass = null;
        try {
            homeInterfaceClass = classLoader.loadClass(this.getInterfaceClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RemoteException("Cannot load the class '" + this.getInterfaceClassName() + "'.", e);
        }
        Class<?> remoteInterfaceClass = null;
        if (this.remoteInterface != null) {
            try {
                remoteInterfaceClass = classLoader.loadClass(this.remoteInterface);
            }
            catch (ClassNotFoundException e) {
                throw new RemoteException("Cannot load the class '" + this.remoteInterface + "'.", e);
            }
        }
        boolean isStateless = !this.isUsingID();
        EasyBeansMetaData metadata = new EasyBeansMetaData(ejbHome, homeInterfaceClass, remoteInterfaceClass, isStateless);
        return metadata;
    }

    private HomeHandle handleGetHomeHandle() {
        return null;
    }
}

