/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.proxy.client.ClientRPCInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCallFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            RefAddr containerIDAddr = ref.get("containerID");
            RefAddr factoryNameAddr = ref.get("factoryName");
            RefAddr itfClassNameAddr = ref.get("interfaceClassName");
            RefAddr useIDAddr = ref.get("useID");
            String containerID = (String)containerIDAddr.getContent();
            String factoryName = (String)factoryNameAddr.getContent();
            String itfClassName = (String)itfClassNameAddr.getContent();
            boolean useID = Boolean.valueOf((String)useIDAddr.getContent());
            ClientRPCInvocationHandler handler = this.buildRemoteHandler(containerID, factoryName, useID);
            handler.setRMIEnv(environment);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clz = null;
            try {
                clz = classLoader.loadClass(itfClassName);
            }
            catch (ClassNotFoundException e) {
                throw new EZBContainerException("Cannot find the class '" + itfClassName + "' in Classloader '" + classLoader + "'.", (Throwable)e);
            }
            handler.setInterfaceClass(clz);
            Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{clz}, (InvocationHandler)handler);
            if (useID) {
                proxy.toString();
            }
            return proxy;
        }
        throw new IllegalStateException("Can only build object with a reference");
    }

    protected ClientRPCInvocationHandler buildRemoteHandler(String containerID, String factoryName, boolean useID) {
        return new ClientRPCInvocationHandler(containerID, factoryName, useID);
    }
}

