/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.play.context.PlayContextFactory;
import org.pac4j.play.http.PlayHttpActionAdapter;
import play.libs.concurrent.HttpExecutionContext;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;

public class LogoutController
extends Controller {
    private LogoutLogic logoutLogic;
    private String defaultUrl;
    private String logoutUrlPattern;
    private Boolean localLogout;
    private Boolean destroySession;
    private Boolean centralLogout;
    @Inject
    protected Config config;
    @Inject
    protected SessionStore sessionStore;
    @Inject
    protected HttpExecutionContext ec;

    public CompletionStage<Result> logout(Http.Request request) {
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)PlayHttpActionAdapter.INSTANCE);
        LogoutLogic bestLogic = FindBest.logoutLogic((LogoutLogic)this.logoutLogic, (Config)this.config, (LogoutLogic)DefaultLogoutLogic.INSTANCE);
        WebContext context = FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)PlayContextFactory.INSTANCE).newContext(new Object[]{request});
        return CompletableFuture.supplyAsync(() -> (Result)bestLogic.perform(context, this.sessionStore, this.config, bestAdapter, this.defaultUrl, this.logoutUrlPattern, this.localLogout, this.destroySession, this.centralLogout), this.ec.current());
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getLogoutUrlPattern() {
        return this.logoutUrlPattern;
    }

    public void setLogoutUrlPattern(String logoutUrlPattern) {
        this.logoutUrlPattern = logoutUrlPattern;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Boolean getLocalLogout() {
        return this.localLogout;
    }

    public void setLocalLogout(Boolean localLogout) {
        this.localLogout = localLogout;
    }

    public Boolean getDestroySession() {
        return this.destroySession;
    }

    public void setDestroySession(Boolean destroySession) {
        this.destroySession = destroySession;
    }

    public Boolean getCentralLogout() {
        return this.centralLogout;
    }

    public void setCentralLogout(Boolean centralLogout) {
        this.centralLogout = centralLogout;
    }

    public LogoutLogic getLogoutLogic() {
        return this.logoutLogic;
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public void setLogoutLogic(LogoutLogic logoutLogic) {
        this.logoutLogic = logoutLogic;
    }
}

