/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.deadbolt2;

import be.objectify.deadbolt.java.DeadboltHandler;
import be.objectify.deadbolt.java.DynamicResourceHandler;
import be.objectify.deadbolt.java.models.Permission;
import be.objectify.deadbolt.java.models.Subject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.StatusAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.deadbolt2.Pac4jRoleHandler;
import org.pac4j.play.deadbolt2.Pac4jSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.concurrent.HttpExecutionContext;
import play.mvc.Http;
import play.mvc.Result;

public class Pac4jHandler
extends DefaultSecurityLogic
implements DeadboltHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jHandler.class);
    private final Config config;
    private final HttpExecutionContext httpExecutionContext;
    private final String clients;
    private final SessionStore sessionStore;
    private final Pac4jRoleHandler rolePermissionsHandler;

    public Pac4jHandler(Config config, HttpExecutionContext httpExecutionContext, String clients, SessionStore sessionStore, Pac4jRoleHandler rolePermissionsHandler) {
        CommonHelper.assertNotNull((String)"config", (Object)config);
        CommonHelper.assertNotNull((String)"httpExecutionContext", (Object)httpExecutionContext);
        CommonHelper.assertNotNull((String)"playSessionStore", (Object)sessionStore);
        this.config = config;
        this.httpExecutionContext = httpExecutionContext;
        this.clients = clients;
        this.sessionStore = sessionStore;
        this.rolePermissionsHandler = rolePermissionsHandler;
    }

    public long getId() {
        return this.clients.hashCode();
    }

    public CompletionStage<Optional<Result>> beforeAuthCheck(Http.RequestHeader requestHeader, Optional<String> content) {
        return CompletableFuture.supplyAsync(() -> {
            HttpAction action;
            Optional<UserProfile> profile = this.getProfile(requestHeader);
            if (profile.isPresent()) {
                LOGGER.debug("profile found -> returning empty");
                return Optional.empty();
            }
            PlayWebContext playWebContext = new PlayWebContext(requestHeader);
            HttpActionAdapter httpActionAdapter = this.config.getHttpActionAdapter();
            List currentClients = this.getClientFinder().find(this.config.getClients(), (WebContext)playWebContext, this.clients);
            LOGGER.debug("currentClients: {}", (Object)currentClients);
            try {
                if (this.startDirectAuthentication(currentClients)) {
                    UserProfile userProfile;
                    LOGGER.debug("Starting direct authentication");
                    DirectClient client = (DirectClient)currentClients.get(0);
                    Optional credentials = client.getCredentials((WebContext)playWebContext, this.sessionStore);
                    if (credentials.isPresent() && (userProfile = ((Credentials)credentials.get()).getUserProfile()) != null) {
                        this.setProfile(requestHeader, userProfile);
                        return Optional.empty();
                    }
                    LOGGER.debug("unauthorized");
                    action = this.unauthorized(playWebContext, this.sessionStore, currentClients);
                } else if (this.startAuthentication(playWebContext, this.sessionStore, currentClients)) {
                    LOGGER.debug("Starting authentication");
                    this.saveRequestedUrl(playWebContext, this.sessionStore, currentClients, null);
                    action = this.redirectToIdentityProvider(playWebContext, this.sessionStore, currentClients);
                } else {
                    LOGGER.debug("unauthorized");
                    action = this.unauthorized(playWebContext, this.sessionStore, currentClients);
                }
            }
            catch (HttpAction e) {
                action = e;
            }
            return Optional.of((Result)httpActionAdapter.adapt(action, (WebContext)playWebContext));
        }, this.httpExecutionContext.current());
    }

    public CompletionStage<Optional<? extends Subject>> getSubject(Http.RequestHeader requestHeader) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<UserProfile> profile = this.getProfile(requestHeader);
            if (profile.isPresent()) {
                LOGGER.debug("profile found: {} -> building a subject", profile);
                return Optional.of(new Pac4jSubject(profile.get()));
            }
            LOGGER.debug("no profile found -> returning empty");
            return Optional.empty();
        }, this.httpExecutionContext.current());
    }

    public CompletionStage<List<? extends Permission>> getPermissionsForRole(String roleName) {
        return this.rolePermissionsHandler.getPermissionsForRole(this.clients, roleName, this.httpExecutionContext);
    }

    private Optional<UserProfile> getProfile(Http.RequestHeader requestHeader) {
        PlayWebContext playWebContext = new PlayWebContext(requestHeader);
        ProfileManager manager = new ProfileManager((WebContext)playWebContext, this.sessionStore);
        return manager.getProfile();
    }

    private void setProfile(Http.RequestHeader requestHeader, UserProfile profile) {
        PlayWebContext playWebContext = new PlayWebContext(requestHeader);
        playWebContext.setRequestAttribute("pac4jUserProfiles", profile);
    }

    public CompletionStage<Result> onAuthFailure(Http.RequestHeader requestHeader, Optional<String> content) {
        return CompletableFuture.supplyAsync(() -> {
            PlayWebContext playWebContext = new PlayWebContext(requestHeader);
            HttpActionAdapter httpActionAdapter = this.config.getHttpActionAdapter();
            return (Result)httpActionAdapter.adapt((HttpAction)new StatusAction(403), (WebContext)playWebContext);
        }, this.httpExecutionContext.current());
    }

    public CompletionStage<Optional<DynamicResourceHandler>> getDynamicResourceHandler(Http.RequestHeader requestHeader) {
        throw new TechnicalException("getDynamicResourceHandler() not supported in Pac4jHandler");
    }

    private boolean startDirectAuthentication(List<Client> currentClients) {
        return CommonHelper.isNotEmpty(currentClients) && currentClients.get(0) instanceof DirectClient;
    }
}

