/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.http;

import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.PlayWebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.http.HttpEntity;
import play.mvc.Result;

public class PlayHttpActionAdapter
implements HttpActionAdapter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final PlayHttpActionAdapter INSTANCE = new PlayHttpActionAdapter();
    protected Map<Integer, Result> results = new HashMap<Integer, Result>();

    public Result adapt(HttpAction action, WebContext context) {
        if (action != null) {
            WithContentAction withContentAction;
            String content;
            int code = action.getCode();
            this.logger.debug("requires HTTP action: {}", (Object)code);
            Result predefinedResult = this.results.get(code);
            if (predefinedResult != null) {
                this.logger.debug("using pre-defined result for code: {}", (Object)code);
                return ((PlayWebContext)context).supplementResponse(predefinedResult);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            HttpEntity httpEntity = HttpEntity.NO_ENTITY;
            if (action instanceof WithLocationAction) {
                WithLocationAction withLocationAction = (WithLocationAction)action;
                headers.put("Location", withLocationAction.getLocation());
            } else if (action instanceof WithContentAction && (content = (withContentAction = (WithContentAction)action).getContent()) != null) {
                this.logger.debug("render: {}", (Object)content);
                httpEntity = HttpEntity.fromString((String)content, (String)"UTF-8");
            }
            return ((PlayWebContext)context).supplementResponse(new Result(code, headers, httpEntity));
        }
        throw new TechnicalException("No action provided");
    }

    public Map<Integer, Result> getResults() {
        return this.results;
    }

    public void setResults(Map<Integer, Result> results) {
        CommonHelper.assertNotNull((String)"results", results);
        this.results = results;
    }
}

