/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.java;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import lombok.Generated;
import org.pac4j.core.adapter.FrameworkAdapter;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.context.PlayFrameworkParameters;
import org.pac4j.play.java.Secure;
import org.pac4j.play.result.PlayWebContextResultHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

public class SecureAction
extends Action<Result> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureAction.class);
    protected static final Method CLIENTS_METHOD;
    protected static final Method AUTHORIZERS_METHOD;
    protected static final Method MATCHERS_METHOD;
    private final Config config;

    @Inject
    public SecureAction(Config config) {
        this.config = config;
    }

    public CompletionStage<Result> call(Http.Request req) {
        try {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.configuration);
            String clients = this.getStringParam(invocationHandler, CLIENTS_METHOD, null);
            String authorizers = this.getStringParam(invocationHandler, AUTHORIZERS_METHOD, null);
            String matchers = this.getStringParam(invocationHandler, MATCHERS_METHOD, null);
            return this.internalCall(new PlayFrameworkParameters((Http.RequestHeader)req), clients, authorizers, matchers);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public CompletionStage<Result> call(PlayFrameworkParameters parameters, String clients, String authorizers, String matchers) throws Throwable {
        return this.internalCall(parameters, clients, authorizers, matchers);
    }

    protected CompletionStage<Result> internalCall(PlayFrameworkParameters parameters, String clients, String authorizers, String matchers) throws Throwable {
        FrameworkAdapter.INSTANCE.applyDefaultSettingsIfUndefined(this.config);
        HttpActionAdapter actionAdapterWrapper = (action, webCtx) -> CompletableFuture.completedFuture(this.config.getHttpActionAdapter().adapt(action, webCtx));
        Config configSecurity = new Config().withClients(this.config.getClients()).withAuthorizers(this.config.getAuthorizers()).withMatchers(this.config.getMatchers()).withSecurityLogic(this.config.getSecurityLogic()).withCallbackLogic(this.config.getCallbackLogic()).withLogoutLogic(this.config.getLogoutLogic()).withWebContextFactory(this.config.getWebContextFactory()).withSessionStoreFactory(this.config.getSessionStoreFactory()).withProfileManagerFactory(this.config.getProfileManagerFactory()).withHttpActionAdapter(actionAdapterWrapper);
        return (CompletionStage)configSecurity.getSecurityLogic().perform(configSecurity, (webCtx, session, profiles) -> {
            PlayWebContext playWebContext = (PlayWebContext)webCtx;
            if (this.delegate == null) {
                return CompletableFuture.completedFuture(new PlayWebContextResultHolder(playWebContext));
            }
            return this.delegate.call(playWebContext.supplementRequest((Http.Request)playWebContext.getNativeJavaRequest()));
        }, clients, authorizers, matchers, (FrameworkParameters)parameters);
    }

    protected String getStringParam(InvocationHandler invocationHandler, Method method, String defaultValue) throws Throwable {
        String value = (String)invocationHandler.invoke(this.configuration, method, null);
        if (value == null) {
            value = defaultValue;
        }
        LOGGER.debug("String param: {}: {}", (Object)method.getName(), (Object)value);
        return value;
    }

    protected boolean getBooleanParam(InvocationHandler invocationHandler, Method method, boolean defaultValue) throws Throwable {
        Boolean value = (Boolean)invocationHandler.invoke(this.configuration, method, null);
        if (value == null) {
            value = defaultValue;
        }
        LOGGER.debug("Boolean param: {}: {}", (Object)method.getName(), (Object)value);
        return value;
    }

    static {
        try {
            CLIENTS_METHOD = Secure.class.getDeclaredMethod("clients", new Class[0]);
            AUTHORIZERS_METHOD = Secure.class.getDeclaredMethod("authorizers", new Class[0]);
            MATCHERS_METHOD = Secure.class.getDeclaredMethod("matchers", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new TechnicalException((Throwable)e);
        }
    }
}

