/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.store;

import com.google.inject.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.Generated;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.store.PlayCacheStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.cache.SyncCacheApi;
import play.mvc.Http;

@Singleton
public class PlayCacheSessionStore
implements SessionStore {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PlayCacheSessionStore.class);
    private String prefix = null;
    protected PlayCacheStore<String, Map<String, Object>> store;

    protected PlayCacheSessionStore() {
    }

    @Inject
    public PlayCacheSessionStore(SyncCacheApi cache) {
        this.store = new PlayCacheStore(cache);
        this.setDefaultTimeout();
    }

    public PlayCacheSessionStore(Provider<SyncCacheApi> cacheProvider) {
        this.store = new PlayCacheStore(cacheProvider);
        this.setDefaultTimeout();
    }

    String getPrefixedSessionKey(String sessionId) {
        if (this.prefix != null) {
            return this.prefix + sessionId;
        }
        return sessionId;
    }

    public Optional<String> getSessionId(WebContext context, boolean createSession) {
        String sessionId = this.getSessionIdFromSessionOrRequest(context);
        if (sessionId == null && createSession) {
            sessionId = UUID.randomUUID().toString();
            LOGGER.debug("generated sessionId: {}", (Object)sessionId);
            this.setSessionIdInSession(context, sessionId);
            context.setRequestAttribute("pac4jSessionId", (Object)sessionId);
        }
        return Optional.ofNullable(sessionId);
    }

    protected String getSessionIdFromSessionOrRequest(WebContext context) {
        String sessionId = ((PlayWebContext)context).getNativeSession().get("pac4jSessionId").orElse(null);
        LOGGER.debug("retrieved sessionId from session: {}", (Object)sessionId);
        if (sessionId == null) {
            sessionId = context.getRequestAttribute("pac4jSessionId").orElse(null);
            LOGGER.debug("retrieved sessionId from request: {}", (Object)sessionId);
            if (sessionId != null) {
                LOGGER.debug("re-saving sessionId in session: {}", (Object)sessionId);
                this.setSessionIdInSession(context, sessionId);
            }
        }
        return sessionId;
    }

    protected void setSessionIdInSession(WebContext context, String sessionId) {
        PlayWebContext playWebContext = (PlayWebContext)context;
        playWebContext.setNativeSession(playWebContext.getNativeSession().adding("pac4jSessionId", sessionId));
    }

    public Optional<Object> get(WebContext context, String key) {
        Optional<String> sessionId = this.getSessionId(context, false);
        if (sessionId.isPresent()) {
            Optional values = this.store.get(this.getPrefixedSessionKey(sessionId.get()));
            Object value = null;
            if (values != null && values.isPresent()) {
                value = ((Map)values.get()).get(key);
            }
            if (value instanceof Exception) {
                LOGGER.debug("Get value: {} for key: {}", (Object)value.toString(), (Object)key);
            } else {
                LOGGER.debug("Get value: {} for key: {}", value, (Object)key);
            }
            return Optional.ofNullable(value);
        }
        LOGGER.debug("Can't get value for key: {}, no session available", (Object)key);
        return Optional.empty();
    }

    public void set(WebContext context, String key, Object value) {
        String sessionId = this.getSessionId(context, true).get();
        String prefixedSessionKey = this.getPrefixedSessionKey(sessionId);
        Optional oldValues = this.store.get(prefixedSessionKey);
        Map<String, Object> values = new HashMap();
        if (oldValues != null && oldValues.isPresent()) {
            values = (Map)oldValues.get();
        }
        if (value instanceof Exception) {
            LOGGER.debug("Set key: {} with value: {}", (Object)key, (Object)value.toString());
        } else {
            LOGGER.debug("Set key: {} with value: {}", (Object)key, value);
        }
        if (value == null) {
            values.remove(key);
        } else {
            values.put(key, value);
        }
        this.store.set(prefixedSessionKey, values);
    }

    public boolean destroySession(WebContext context) {
        String sessionId = this.getSessionIdFromSessionOrRequest(context);
        if (sessionId != null) {
            LOGGER.debug("Invalidate session: {}", (Object)sessionId);
            ((PlayWebContext)context).setNativeSession(new Http.Session(new HashMap()));
            context.setRequestAttribute("pac4jSessionId", null);
            String prefixedSessionKey = this.getPrefixedSessionKey(sessionId);
            this.store.remove(prefixedSessionKey);
        }
        return true;
    }

    public Optional<Object> getTrackableSession(WebContext context) {
        String sessionId = this.getSessionIdFromSessionOrRequest(context);
        LOGGER.debug("Return trackable session: {}", (Object)sessionId);
        return Optional.ofNullable(sessionId);
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        if (trackableSession != null) {
            LOGGER.debug("Rebuild session from trackable session: {}", trackableSession);
            this.setSessionIdInSession(context, (String)trackableSession);
            context.setRequestAttribute("pac4jSessionId", trackableSession);
            return Optional.of(this);
        }
        LOGGER.debug("Unable to build session from trackable session");
        return Optional.empty();
    }

    public boolean renewSession(WebContext context) {
        Optional<String> oldSessionId = this.getSessionId(context, false);
        HashMap oldData = new HashMap();
        oldSessionId.ifPresent(sessionId -> {
            String prefixedSessionId = this.getPrefixedSessionKey((String)sessionId);
            Optional optOldData = this.store.get(prefixedSessionId);
            optOldData.ifPresent(oldDataMap -> {
                oldData.putAll((Map)optOldData.get());
                this.store.remove(prefixedSessionId);
            });
        });
        PlayWebContext playWebContext = (PlayWebContext)context;
        playWebContext.setNativeSession(playWebContext.getNativeSession().removing(new String[]{"pac4jSessionId"}));
        context.setRequestAttribute("pac4jSessionId", null);
        String newSessionId = this.getSessionId(context, true).get();
        if (oldData.size() > 0) {
            this.store.set(this.getPrefixedSessionKey(newSessionId), oldData);
        }
        LOGGER.debug("Renewing session: {} -> {}", oldSessionId, (Object)newSessionId);
        return true;
    }

    public int getTimeout() {
        return this.store.getTimeout();
    }

    public void setTimeout(int timeout) {
        this.store.setTimeout(timeout);
    }

    protected void setDefaultTimeout() {
        this.store.setTimeout(3600);
    }

    @Generated
    public String toString() {
        return "PlayCacheSessionStore(prefix=" + this.prefix + ", store=" + this.store + ")";
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

