/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.store;

import com.google.inject.Provider;
import java.util.Optional;
import javax.inject.Inject;
import lombok.Generated;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.store.AbstractStore;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.serializer.JsonSerializer;
import org.pac4j.core.util.serializer.Serializer;
import play.cache.SyncCacheApi;

public class PlayCacheStore<K, O>
extends AbstractStore<K, O> {
    private final SyncCacheApi cache;
    private final Provider<SyncCacheApi> cacheProvider;
    private int timeout;
    private Serializer serializer = new JsonSerializer();

    @Inject
    public PlayCacheStore(SyncCacheApi cacheApi) {
        this.cacheProvider = null;
        this.cache = cacheApi;
    }

    public PlayCacheStore(Provider<SyncCacheApi> cacheProvider) {
        this.cache = null;
        this.cacheProvider = cacheProvider;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertTrue((this.timeout >= 0 ? 1 : 0) != 0, (String)"timeout must be greater than zero");
        if (this.cache == null && this.cacheProvider == null) {
            throw new TechnicalException("The cache and the cacheProvider must not both be null");
        }
    }

    protected Optional<O> internalGet(K key) {
        return this.getCache().get(this.computeKey(key));
    }

    protected void internalSet(K key, O value) {
        this.getCache().set(this.computeKey(key), value, this.timeout);
    }

    protected void internalRemove(K key) {
        this.getCache().remove(this.computeKey(key));
    }

    protected String computeKey(Object objKey) {
        if (objKey instanceof String) {
            return (String)objKey;
        }
        return this.serializer.serializeToString(objKey);
    }

    public SyncCacheApi getCache() {
        return this.cache != null ? this.cache : (SyncCacheApi)this.cacheProvider.get();
    }

    @Generated
    public String toString() {
        return "PlayCacheStore(cache=" + this.cache + ", cacheProvider=" + this.cacheProvider + ", timeout=" + this.timeout + ", serializer=" + this.serializer + ")";
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Generated
    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }
}

