/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.authentication;

import java.util.List;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.springframework.security.authentication.Pac4jAuthentication;
import org.pac4j.springframework.security.util.SpringSecurityHelper;
import org.springframework.security.authentication.AbstractAuthenticationToken;

public class Pac4jAuthenticationToken
extends AbstractAuthenticationToken
implements Pac4jAuthentication {
    private final List<UserProfile> profiles;
    private final UserProfile profile;

    public Pac4jAuthenticationToken(List<UserProfile> profiles) {
        super(SpringSecurityHelper.buildAuthorities(profiles));
        this.profiles = profiles;
        this.profile = (UserProfile)ProfileHelper.flatIntoOneProfile(profiles).get();
        this.setAuthenticated(true);
    }

    public String getName() {
        return this.profile.getId();
    }

    public Object getCredentials() {
        return "";
    }

    public Object getPrincipal() {
        return this.profile;
    }

    @Override
    public List<UserProfile> getProfiles() {
        return this.profiles;
    }
}

