/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.IsFullyAuthenticatedAuthorizer;
import org.pac4j.core.authorization.authorizer.IsRememberedAuthorizer;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.springframework.security.authentication.Pac4jAuthenticationToken;
import org.pac4j.springframework.security.authentication.Pac4jRememberMeAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public final class SpringSecurityHelper {
    private static final Authorizer IS_REMEMBERED_AUTHORIZER = new IsRememberedAuthorizer();
    private static final Authorizer IS_FULLY_AUTHENTICATED_AUTHORIZER = new IsFullyAuthenticatedAuthorizer();

    public static List<GrantedAuthority> buildAuthorities(List<UserProfile> profiles) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (UserProfile profile : profiles) {
            Set roles = profile.getRoles();
            for (String role : roles) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
            }
        }
        return authorities;
    }

    public static Optional<Authentication> computeAuthentication(LinkedHashMap<String, UserProfile> profiles) {
        if (profiles != null && profiles.size() > 0) {
            List listProfiles = ProfileHelper.flatIntoAProfileList(profiles);
            if (IS_FULLY_AUTHENTICATED_AUTHORIZER.isAuthorized(null, null, listProfiles)) {
                return Optional.of(new Pac4jAuthenticationToken(listProfiles));
            }
            if (IS_REMEMBERED_AUTHORIZER.isAuthorized(null, null, listProfiles)) {
                return Optional.of(new Pac4jRememberMeAuthenticationToken(listProfiles));
            }
        }
        return Optional.empty();
    }
}

