/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.httpclient;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.openstack4j.api.exceptions.ConnectionException;
import org.openstack4j.api.exceptions.ResponseException;
import org.openstack4j.connectors.httpclient.HttpCommand;
import org.openstack4j.connectors.httpclient.HttpResponseImpl;
import org.openstack4j.core.transport.HttpExecutorService;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.openstack.internal.OSAuthenticator;
import org.openstack4j.openstack.internal.OSClientSession;
import org.openstack4j.openstack.logging.Logger;
import org.openstack4j.openstack.logging.LoggerFactory;

public class HttpExecutorServiceImpl
implements HttpExecutorService {
    private static final String NAME = "Apache HttpClient Connector";
    private static final Logger LOG = LoggerFactory.getLogger(HttpExecutorServiceImpl.class);

    public <R> HttpResponse execute(HttpRequest<R> request) {
        try {
            return this.invoke(request);
        }
        catch (ResponseException re) {
            throw re;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), new Object[]{e});
            return null;
        }
    }

    private <R> HttpResponse invoke(HttpRequest<R> request) throws Exception {
        HttpCommand<R> command = HttpCommand.create(request);
        try {
            return this.invokeRequest(command);
        }
        catch (ResponseException re) {
            throw re;
        }
        catch (Exception pe) {
            throw new ConnectionException(pe.getMessage(), 0, (Throwable)pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> HttpResponse invokeRequest(HttpCommand<R> command) throws Exception {
        CloseableHttpResponse response = command.execute();
        if (command.getRetries() == 0 && response.getStatusLine().getStatusCode() == 401 && !command.getRequest().getHeaders().containsKey("OS4J-Auth-Command")) {
            try {
                OSAuthenticator.reAuthenticate();
                command.getRequest().getHeaders().put("X-Auth-Token", OSClientSession.getCurrent().getTokenId());
                HttpResponse httpResponse = this.invokeRequest(command.incrementRetriesAndReturn());
                return httpResponse;
            }
            finally {
                response.close();
            }
        }
        return HttpResponseImpl.wrap(response);
    }

    public String getExecutorDisplayName() {
        return NAME;
    }
}

