/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.jersey2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.ContextResolver;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.openstack4j.api.exceptions.ConnectionException;
import org.openstack4j.core.transport.Config;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.core.transport.UntrustedSSL;

class ClientFactory {
    private static final CustomContextResolver RESOLVER = new CustomContextResolver();
    private static LoadingCache<Config, Client> CACHE = CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Config, Client>(){

        public Client load(Config config) throws Exception {
            return ClientFactory.buildClientFromConfig(config);
        }
    });

    ClientFactory() {
    }

    static Client create(Config config) {
        try {
            return (Client)CACHE.get((Object)config);
        }
        catch (ExecutionException e) {
            throw new ConnectionException("Issue creating Jersey 2 Client: " + e.getMessage(), 0, (Throwable)e);
        }
    }

    private static Client buildClientFromConfig(Config config) {
        ClientConfig clientConfig = new ClientConfig();
        if (config.getProxy() != null) {
            ClientFactory.addProxy(clientConfig, config);
        }
        ClientBuilder cb = (ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().withConfig((Configuration)clientConfig).property("jersey.config.client.suppressHttpComplianceValidation", (Object)"true")).register(JacksonFeature.class)).register((Object)RESOLVER)).register((Object)new RequestFilter());
        if (config.getSslContext() != null) {
            cb.sslContext(config.getSslContext());
        } else if (config.isIgnoreSSLVerification()) {
            cb.sslContext(UntrustedSSL.getSSLContext());
        }
        if (config.getHostNameVerifier() != null) {
            cb.hostnameVerifier(config.getHostNameVerifier());
        } else if (config.isIgnoreSSLVerification()) {
            cb.hostnameVerifier(UntrustedSSL.getHostnameVerifier());
        }
        if (config.getReadTimeout() > 0) {
            cb.property("jersey.config.client.readTimeout", (Object)config.getReadTimeout());
        }
        if (config.getConnectTimeout() > 0) {
            cb.property("jersey.config.client.connectTimeout", (Object)config.getConnectTimeout());
        }
        return cb.build();
    }

    private static void addProxy(ClientConfig cc, Config config) {
        if (config.getProxy() != null) {
            HttpUrlConnectorProvider cp = new HttpUrlConnectorProvider();
            cc.connectorProvider((ConnectorProvider)cp);
            final Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxy().getRawHost(), config.getProxy().getPort()));
            cp.connectionFactory(new HttpUrlConnectorProvider.ConnectionFactory(){

                public HttpURLConnection getConnection(URL url) throws IOException {
                    return (HttpURLConnection)url.openConnection(proxy);
                }
            });
        }
    }

    private static final class CustomContextResolver
    implements ContextResolver<ObjectMapper> {
        private CustomContextResolver() {
        }

        public ObjectMapper getContext(Class<?> type) {
            return ObjectMapperSingleton.getContext(type);
        }
    }

    private static final class RequestFilter
    implements ClientRequestFilter {
        private RequestFilter() {
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            requestContext.getHeaders().remove((Object)"Content-Language");
            requestContext.getHeaders().remove((Object)"Content-Encoding");
        }
    }
}

