/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.pcollections.PMap;
import org.pcollections.PSet;

public final class MapPSet<E>
extends AbstractSet<E>
implements PSet<E> {
    private final PMap<E, Object> map;

    public static <E> MapPSet<E> from(PMap<E, ?> map) {
        return new MapPSet<E>(map);
    }

    public static <E> MapPSet<E> from(PMap<E, ?> map, E e) {
        return MapPSet.from(map).plus((Object)e);
    }

    public static <E> MapPSet<E> from(PMap<E, ?> map, Collection<? extends E> list) {
        return MapPSet.from(map).plusAll((Collection)list);
    }

    private MapPSet(PMap<E, Object> map) {
        this.map = map;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(Object e) {
        return this.map.containsKey(e);
    }

    @Override
    public MapPSet<E> plus(E e) {
        if (this.contains(e)) {
            return this;
        }
        return new MapPSet<E>(this.map.plus(e, (Object)In.IN));
    }

    @Override
    public MapPSet<E> minus(Object e) {
        if (!this.contains(e)) {
            return this;
        }
        return new MapPSet<E>(this.map.minus(e));
    }

    @Override
    public MapPSet<E> plusAll(Collection<? extends E> list) {
        PMap<E, Object> map = this.map;
        for (E e : list) {
            map = map.plus(e, (Object)In.IN);
        }
        return MapPSet.from(map);
    }

    @Override
    public MapPSet<E> minusAll(Collection<?> list) {
        PMap<E, Object> map = this.map.minusAll(list);
        return MapPSet.from(map);
    }

    private static enum In {
        IN;

    }
}

