/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.packageManagement;

import org.pentaho.packageManagement.Package;
import org.pentaho.packageManagement.PackageConstraint;
import org.pentaho.packageManagement.VersionPackageConstraint;

public class VersionRangePackageConstraint
extends PackageConstraint {
    protected String m_lowerBound;
    protected VersionPackageConstraint.VersionComparison m_lowerConstraint;
    protected String m_upperBound;
    protected VersionPackageConstraint.VersionComparison m_upperConstraint;
    protected boolean m_boundOr;

    public VersionRangePackageConstraint(Package p) {
        this.setPackage(p);
    }

    public void setRangeConstraint(String bound1, VersionPackageConstraint.VersionComparison comp1, String bound2, VersionPackageConstraint.VersionComparison comp2) throws Exception {
        if (comp1 == VersionPackageConstraint.VersionComparison.EQUAL || comp2 == VersionPackageConstraint.VersionComparison.EQUAL) {
            throw new Exception("[VersionRangePackageConstraint] malformed version range constraint (= not allowed)!");
        }
        if (comp1.compatibleWith(comp2)) {
            throw new Exception("[VersionRangePackageConstraint] malformed version range constraint!");
        }
        VersionPackageConstraint.VersionComparison boundsComp = VersionPackageConstraint.compare(bound1, bound2);
        if (boundsComp == VersionPackageConstraint.VersionComparison.EQUAL) {
            throw new Exception("[VersionRangePackageConstraint] malformed version range - both bounds are equal!");
        }
        if (comp1 == VersionPackageConstraint.VersionComparison.GREATERTHAN || comp1 == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
            if (boundsComp == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                this.m_boundOr = true;
            }
        } else if (boundsComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            this.m_boundOr = true;
        }
        if (boundsComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            this.m_lowerBound = bound1;
            this.m_lowerConstraint = comp1;
            this.m_upperBound = bound2;
            this.m_upperConstraint = comp2;
        } else {
            this.m_lowerBound = bound2;
            this.m_lowerConstraint = comp2;
            this.m_upperBound = bound1;
            this.m_upperConstraint = comp1;
        }
    }

    public String getLowerBound() {
        return this.m_lowerBound;
    }

    public String getUpperBound() {
        return this.m_upperBound;
    }

    public VersionPackageConstraint.VersionComparison getLowerComparison() {
        return this.m_lowerConstraint;
    }

    public VersionPackageConstraint.VersionComparison getUpperComparison() {
        return this.m_upperConstraint;
    }

    public boolean isBoundOR() {
        return this.m_boundOr;
    }

    protected static boolean checkConstraint(String toCheck, VersionPackageConstraint.VersionComparison comp1, String bound1, VersionPackageConstraint.VersionComparison comp2, String bound2, boolean boundOr) {
        boolean result1 = VersionPackageConstraint.checkConstraint(toCheck, comp1, bound1);
        boolean result2 = VersionPackageConstraint.checkConstraint(toCheck, comp2, bound2);
        if (boundOr) {
            return result1 || result2;
        }
        return result1 && result2;
    }

    @Override
    public boolean checkConstraint(Package target) throws Exception {
        if (this.m_lowerConstraint == null || this.m_upperConstraint == null) {
            throw new Exception("[VersionRangePackageConstraint] No constraint has been set!");
        }
        String targetVersion = target.getPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY).toString();
        return VersionRangePackageConstraint.checkConstraint(targetVersion, this.m_lowerConstraint, this.m_lowerBound, this.m_upperConstraint, this.m_upperBound, this.m_boundOr);
    }

    protected PackageConstraint checkTargetVersionRangePackageConstraint(VersionRangePackageConstraint target) throws Exception {
        VersionPackageConstraint.VersionComparison upperComp;
        String targetLowerBound = target.getLowerBound();
        String targetUpperBound = target.getUpperBound();
        VersionPackageConstraint.VersionComparison targetLowerComp = target.getLowerComparison();
        VersionPackageConstraint.VersionComparison targetUpperComp = target.getUpperComparison();
        if (!this.m_boundOr) {
            VersionPackageConstraint.VersionComparison disjointCheck;
            VersionPackageConstraint.VersionComparison upperComp2;
            if (target.isBoundOR()) {
                Package p = (Package)target.getPackage().clone();
                p.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, target.getLowerBound());
                VersionPackageConstraint lowerC = new VersionPackageConstraint(p);
                lowerC.setVersionConstraint(target.getLowerComparison());
                p = (Package)p.clone();
                p.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, target.getUpperBound());
                VersionPackageConstraint upperC = new VersionPackageConstraint(p);
                upperC.setVersionConstraint(target.getUpperComparison());
                PackageConstraint coveringLower = this.checkTargetVersionPackageConstraint(lowerC);
                if (coveringLower != null) {
                    return coveringLower;
                }
                PackageConstraint coveringUpper = this.checkTargetVersionPackageConstraint(upperC);
                return coveringUpper;
            }
            String resultLowerBound = null;
            String resultUpperBound = null;
            VersionPackageConstraint.VersionComparison resultLowerComp = null;
            VersionPackageConstraint.VersionComparison resultUpperComp = null;
            VersionPackageConstraint.VersionComparison lowerComp = VersionPackageConstraint.compare(this.m_lowerBound, targetLowerBound);
            if (lowerComp == VersionPackageConstraint.VersionComparison.EQUAL) {
                resultLowerBound = this.m_lowerBound;
                resultLowerComp = VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL;
                if (targetLowerComp == VersionPackageConstraint.VersionComparison.GREATERTHAN || this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                    resultLowerComp = VersionPackageConstraint.VersionComparison.GREATERTHAN;
                }
            } else if (lowerComp == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                resultLowerBound = this.m_lowerBound;
                resultLowerComp = this.m_lowerConstraint;
            } else {
                resultLowerBound = targetLowerBound;
                resultLowerComp = targetLowerComp;
            }
            if ((upperComp2 = VersionPackageConstraint.compare(this.m_upperBound, targetUpperBound)) == VersionPackageConstraint.VersionComparison.EQUAL) {
                resultUpperBound = this.m_upperBound;
                resultUpperComp = VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL;
                if (targetUpperComp == VersionPackageConstraint.VersionComparison.LESSTHAN || this.m_upperConstraint == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                    resultUpperComp = VersionPackageConstraint.VersionComparison.LESSTHAN;
                }
            } else if (upperComp2 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                resultUpperBound = this.m_upperBound;
                resultUpperComp = this.m_upperConstraint;
            } else {
                resultUpperBound = targetUpperBound;
                resultUpperComp = targetUpperComp;
            }
            if ((disjointCheck = VersionPackageConstraint.compare(resultUpperBound, resultLowerBound)) == VersionPackageConstraint.VersionComparison.LESSTHAN || disjointCheck == VersionPackageConstraint.VersionComparison.EQUAL) {
                return null;
            }
            VersionRangePackageConstraint result = new VersionRangePackageConstraint(this.getPackage());
            result.setRangeConstraint(resultLowerBound, resultLowerComp, resultUpperBound, resultUpperComp);
            return result;
        }
        if (!target.isBoundOR()) {
            Package p = (Package)this.getPackage().clone();
            p.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, this.m_lowerBound);
            VersionPackageConstraint lowerC = new VersionPackageConstraint(p);
            lowerC.setVersionConstraint(this.m_lowerConstraint);
            p = (Package)p.clone();
            p.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, this.m_upperBound);
            VersionPackageConstraint upperC = new VersionPackageConstraint(p);
            upperC.setVersionConstraint(this.m_upperConstraint);
            PackageConstraint coveringLower = target.checkTargetVersionPackageConstraint(lowerC);
            if (coveringLower != null) {
                return coveringLower;
            }
            PackageConstraint coveringUpper = this.checkTargetVersionPackageConstraint(upperC);
            return coveringUpper;
        }
        String resultLowerBound = null;
        String resultUpperBound = null;
        VersionPackageConstraint.VersionComparison resultLowerComp = null;
        VersionPackageConstraint.VersionComparison resultUpperComp = null;
        VersionPackageConstraint.VersionComparison lowerComp = VersionPackageConstraint.compare(this.m_lowerBound, targetLowerBound);
        if (lowerComp == VersionPackageConstraint.VersionComparison.EQUAL) {
            resultLowerBound = this.m_lowerBound;
            resultLowerComp = VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL;
            if (targetLowerComp == VersionPackageConstraint.VersionComparison.LESSTHAN || this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                resultLowerComp = VersionPackageConstraint.VersionComparison.LESSTHAN;
            }
        } else if (lowerComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            resultLowerBound = this.m_lowerBound;
            resultLowerComp = this.m_lowerConstraint;
        } else {
            resultLowerBound = targetLowerBound;
            resultLowerComp = targetLowerComp;
        }
        if ((upperComp = VersionPackageConstraint.compare(this.m_upperBound, targetUpperBound)) == VersionPackageConstraint.VersionComparison.EQUAL) {
            resultUpperBound = this.m_upperBound;
            resultUpperComp = VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL;
            if (targetUpperComp == VersionPackageConstraint.VersionComparison.GREATERTHAN || this.m_upperConstraint == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                resultUpperComp = VersionPackageConstraint.VersionComparison.GREATERTHAN;
            }
        } else if (upperComp == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
            resultUpperBound = this.m_upperBound;
            resultUpperComp = this.m_upperConstraint;
        } else {
            resultUpperBound = targetUpperBound;
            resultUpperComp = targetUpperComp;
        }
        VersionRangePackageConstraint result = new VersionRangePackageConstraint(this.getPackage());
        result.setRangeConstraint(resultLowerBound, resultLowerComp, resultUpperBound, resultUpperComp);
        return result;
    }

    protected PackageConstraint checkTargetVersionPackageConstraint(VersionPackageConstraint target) throws Exception {
        VersionPackageConstraint.VersionComparison targetComp = target.getVersionComparison();
        String targetVersion = target.getPackage().getPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY).toString();
        VersionPackageConstraint.VersionComparison lowerComp = VersionPackageConstraint.compare(targetVersion, this.m_lowerBound);
        VersionPackageConstraint.VersionComparison upperComp = VersionPackageConstraint.compare(targetVersion, this.m_upperBound);
        boolean lowerCheck = false;
        boolean upperCheck = false;
        String coveringLowerBound = null;
        String coveringUpperBound = null;
        VersionPackageConstraint.VersionComparison coveringLowerConstraint = null;
        VersionPackageConstraint.VersionComparison coveringUpperConstraint = null;
        if (targetComp == VersionPackageConstraint.VersionComparison.EQUAL) {
            if (this.checkConstraint(target.getPackage())) {
                return target;
            }
            return null;
        }
        if (this.m_boundOr) {
            if (this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                if (lowerComp == VersionPackageConstraint.VersionComparison.EQUAL || lowerComp == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                    if (targetComp == VersionPackageConstraint.VersionComparison.GREATERTHAN || targetComp == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                        lowerCheck = false;
                    } else {
                        lowerCheck = true;
                        coveringLowerBound = this.m_lowerBound;
                        coveringLowerConstraint = this.m_lowerConstraint;
                    }
                } else if (lowerComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                    lowerCheck = true;
                    coveringLowerBound = targetVersion;
                    coveringLowerConstraint = targetComp;
                    if (targetComp == VersionPackageConstraint.VersionComparison.LESSTHAN || targetComp == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                        coveringUpperBound = null;
                    } else {
                        coveringUpperBound = this.m_lowerBound;
                        coveringUpperConstraint = this.m_lowerConstraint;
                    }
                }
            } else if (lowerComp == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                if (targetComp == VersionPackageConstraint.VersionComparison.GREATERTHAN || targetComp == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                    lowerCheck = false;
                } else {
                    lowerCheck = true;
                    coveringLowerBound = this.m_lowerBound;
                    coveringLowerConstraint = this.m_lowerConstraint;
                }
            } else if (lowerComp == VersionPackageConstraint.VersionComparison.EQUAL) {
                if (targetComp == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                    lowerCheck = false;
                } else {
                    lowerCheck = true;
                    coveringLowerBound = targetVersion;
                    coveringLowerConstraint = targetComp;
                    coveringUpperBound = null;
                }
            } else {
                lowerCheck = true;
                coveringLowerBound = targetVersion;
                coveringLowerConstraint = targetComp;
                if (targetComp == VersionPackageConstraint.VersionComparison.LESSTHAN || targetComp == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                    coveringUpperBound = null;
                } else {
                    coveringUpperBound = this.m_lowerBound;
                    coveringUpperConstraint = this.m_lowerConstraint;
                }
            }
            if (!lowerCheck) {
                if (this.m_upperConstraint == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                    if (upperComp == VersionPackageConstraint.VersionComparison.EQUAL || upperComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                        if (targetComp == VersionPackageConstraint.VersionComparison.LESSTHAN || targetComp == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                            upperCheck = false;
                        } else {
                            lowerCheck = true;
                            coveringUpperBound = this.m_upperBound;
                            coveringUpperConstraint = this.m_upperConstraint;
                        }
                    } else if (upperComp == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                        upperCheck = true;
                        coveringUpperBound = targetVersion;
                        coveringUpperConstraint = targetComp;
                        if (targetComp == VersionPackageConstraint.VersionComparison.GREATERTHAN || targetComp == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                            coveringLowerBound = null;
                        } else {
                            coveringLowerBound = this.m_upperBound;
                            coveringLowerConstraint = this.m_upperConstraint;
                        }
                    }
                } else if (upperComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                    if (targetComp == VersionPackageConstraint.VersionComparison.LESSTHAN || targetComp == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                        upperCheck = false;
                    } else {
                        upperCheck = true;
                        coveringUpperBound = this.m_upperBound;
                        coveringUpperConstraint = this.m_upperConstraint;
                    }
                } else if (upperComp == VersionPackageConstraint.VersionComparison.EQUAL) {
                    if (targetComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                        upperCheck = false;
                    } else {
                        upperCheck = true;
                        coveringUpperBound = targetVersion;
                        coveringUpperConstraint = targetComp;
                        coveringLowerBound = null;
                    }
                } else {
                    upperCheck = true;
                    coveringUpperBound = targetVersion;
                    coveringUpperConstraint = targetComp;
                    if (targetComp == VersionPackageConstraint.VersionComparison.GREATERTHAN || targetComp == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                        coveringLowerBound = null;
                    } else {
                        coveringLowerBound = this.m_upperBound;
                        coveringLowerConstraint = this.m_upperConstraint;
                    }
                }
            }
            if (!lowerCheck && !upperCheck) {
                throw new Exception("[VersionRangePackageConstraint] This shouldn't be possible!!");
            }
            if (coveringLowerBound != null && coveringUpperBound != null) {
                VersionRangePackageConstraint result = new VersionRangePackageConstraint(this.getPackage());
                result.setRangeConstraint(coveringLowerBound, coveringLowerConstraint, coveringUpperBound, coveringUpperConstraint);
                return result;
            }
            String newVersionNumber = coveringLowerBound != null ? coveringLowerBound : coveringUpperBound;
            VersionPackageConstraint.VersionComparison newConstraint = coveringLowerConstraint != null ? coveringLowerConstraint : coveringUpperConstraint;
            Package p = (Package)this.getPackage().clone();
            p.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, newVersionNumber);
            VersionPackageConstraint result = new VersionPackageConstraint(p);
            result.setVersionConstraint(newConstraint);
            return result;
        }
        if (lowerComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            if (targetComp == VersionPackageConstraint.VersionComparison.LESSTHAN || targetComp == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL || targetComp == VersionPackageConstraint.VersionComparison.EQUAL) {
                lowerCheck = false;
            } else {
                lowerCheck = true;
                coveringLowerBound = this.m_lowerBound;
                coveringLowerConstraint = this.m_lowerConstraint;
                coveringUpperBound = this.m_upperBound;
                coveringUpperConstraint = this.m_upperConstraint;
            }
        } else if (lowerComp == VersionPackageConstraint.VersionComparison.EQUAL) {
            if (targetComp == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL || targetComp == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                lowerCheck = true;
                coveringLowerBound = this.m_lowerBound;
                coveringLowerConstraint = this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.GREATERTHAN || targetComp == VersionPackageConstraint.VersionComparison.GREATERTHAN ? VersionPackageConstraint.VersionComparison.GREATERTHAN : VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL;
                coveringUpperBound = this.m_upperBound;
                coveringUpperConstraint = this.m_upperConstraint;
            } else if (targetComp == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL && this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                VersionPackageConstraint.VersionComparison newComp = VersionPackageConstraint.VersionComparison.EQUAL;
                VersionPackageConstraint result = new VersionPackageConstraint(target.getPackage());
                result.setVersionConstraint(newComp);
                return result;
            }
        } else if (lowerComp == VersionPackageConstraint.VersionComparison.GREATERTHAN && upperComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            if (targetComp == VersionPackageConstraint.VersionComparison.LESSTHAN || targetComp == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                lowerCheck = true;
                upperCheck = true;
                coveringLowerBound = this.m_lowerBound;
                coveringLowerConstraint = this.m_lowerConstraint;
                coveringUpperBound = targetVersion;
                coveringUpperConstraint = targetComp;
            } else {
                coveringLowerBound = targetVersion;
                coveringLowerConstraint = targetComp;
                coveringUpperBound = this.m_upperBound;
                coveringUpperConstraint = this.m_upperConstraint;
            }
        }
        if (coveringLowerBound == null || coveringUpperBound == null) {
            if (upperComp == VersionPackageConstraint.VersionComparison.EQUAL) {
                if (targetComp == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL || targetComp == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                    upperCheck = true;
                    coveringUpperBound = this.m_upperBound;
                    coveringUpperConstraint = this.m_upperConstraint == VersionPackageConstraint.VersionComparison.LESSTHAN || targetComp == VersionPackageConstraint.VersionComparison.LESSTHAN ? VersionPackageConstraint.VersionComparison.LESSTHAN : VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL;
                    coveringLowerBound = this.m_lowerBound;
                    coveringLowerConstraint = this.m_lowerConstraint;
                } else if (targetComp == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL && this.m_upperConstraint == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                    VersionPackageConstraint.VersionComparison newComp = VersionPackageConstraint.VersionComparison.EQUAL;
                    VersionPackageConstraint result = new VersionPackageConstraint(target.getPackage());
                    result.setVersionConstraint(newComp);
                    return result;
                }
            } else if (upperComp == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                if (targetComp == VersionPackageConstraint.VersionComparison.GREATERTHAN || targetComp == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL || targetComp == VersionPackageConstraint.VersionComparison.EQUAL) {
                    upperCheck = false;
                } else {
                    upperCheck = true;
                    coveringUpperBound = this.m_upperBound;
                    coveringUpperConstraint = this.m_upperConstraint;
                    coveringLowerBound = this.m_lowerBound;
                    coveringLowerConstraint = this.m_lowerConstraint;
                }
            }
        }
        if (coveringUpperBound == null && coveringLowerBound == null) {
            return null;
        }
        if (coveringUpperBound == null || coveringLowerBound == null) {
            throw new Exception("[VersionRangePackageConstraint] This shouldn't be possible!!");
        }
        VersionRangePackageConstraint result = new VersionRangePackageConstraint(this.getPackage());
        result.setRangeConstraint(coveringLowerBound, coveringLowerConstraint, coveringUpperBound, coveringUpperConstraint);
        return result;
    }

    @Override
    public PackageConstraint checkConstraint(PackageConstraint target) throws Exception {
        if (this.m_lowerConstraint == null || this.m_upperConstraint == null) {
            throw new Exception("[VersionRangePackageConstraint] No constraint has been set!");
        }
        if (!(target instanceof VersionRangePackageConstraint) && !(target instanceof VersionPackageConstraint)) {
            throw new Exception("[VersionRangePackageConstraint] incompatible target constraint!");
        }
        if (target instanceof VersionPackageConstraint) {
            PackageConstraint result = this.checkTargetVersionPackageConstraint((VersionPackageConstraint)target);
            return result;
        }
        if (target instanceof VersionRangePackageConstraint) {
            PackageConstraint result = this.checkTargetVersionRangePackageConstraint((VersionRangePackageConstraint)target);
            return result;
        }
        return null;
    }
}

