/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.model.hibernate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttributeBinaryValue;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;

public class HibernateIdentityObjectAttribute
implements IdentityObjectAttribute {
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_BINARY = "binary";
    private Long id;
    private HibernateIdentityObject identityObject;
    private String name;
    private String type;
    private HibernateIdentityObjectAttributeBinaryValue binaryValue = null;
    private Set<String> textValues = new HashSet<String>();

    public HibernateIdentityObjectAttribute() {
    }

    public HibernateIdentityObjectAttribute(HibernateIdentityObject identityObject, String name, String type) {
        this.identityObject = identityObject;
        this.name = name;
        this.setType(type);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HibernateIdentityObject getIdentityObject() {
        return this.identityObject;
    }

    public void setIdentityObject(HibernateIdentityObject identityObject) {
        this.identityObject = identityObject;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        if (!newType.equals(TYPE_TEXT) && !newType.equals(TYPE_BINARY)) {
            throw new IllegalArgumentException("Type has not supported value. Name=" + this.name + "; type=" + this.type);
        }
        this.type = newType;
    }

    public HibernateIdentityObjectAttributeBinaryValue getBinaryValue() {
        return this.binaryValue;
    }

    public void setBinaryValue(HibernateIdentityObjectAttributeBinaryValue binaryValue) {
        this.binaryValue = binaryValue;
    }

    public Set<String> getTextValues() {
        return Collections.unmodifiableSet(this.textValues);
    }

    public void setTextValues(Collection<String> textValues) {
        this.textValues.clear();
        this.textValues.addAll(textValues);
    }

    public void addTextValue(String value) {
        this.getTextValues().add(value);
    }

    public Object getValue() {
        if (this.type.equals(TYPE_TEXT)) {
            if (this.getTextValues().size() > 0) {
                return this.getTextValues().iterator().next();
            }
            return null;
        }
        if (this.type.equals(TYPE_BINARY)) {
            return this.getBinaryValue().getValue();
        }
        throw new IllegalStateException("Type has not supported value. Name=" + this.name + "; type=" + this.type);
    }

    public void addValue(Object value) {
        if (this.type.equals(TYPE_TEXT)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("String value expected with a set type. Name=" + this.name + "; type=" + this.type);
            }
            this.addTextValue((String)value);
        } else if (this.type.equals(TYPE_BINARY)) {
            if (!(value instanceof byte[])) {
                throw new IllegalArgumentException("byte[] value expected with a set type. Name=" + this.name + "; type=" + this.type);
            }
            this.setBinaryValue(new HibernateIdentityObjectAttributeBinaryValue((byte[])value));
        } else {
            throw new IllegalStateException("Type has not supported value or has not been set. Name=" + this.name + "; type=" + this.type);
        }
    }

    public Collection getValues() {
        if (this.type.equals(TYPE_TEXT)) {
            return Collections.unmodifiableSet(this.getTextValues());
        }
        if (this.type.equals(TYPE_BINARY)) {
            HashSet<byte[]> vals = new HashSet<byte[]>();
            vals.add(this.getBinaryValue().getValue());
            return vals;
        }
        throw new IllegalStateException("Type has not supported value. Name=" + this.name + "; type=" + this.type);
    }

    public int getSize() {
        if (this.type.equals(TYPE_TEXT)) {
            return this.getTextValues().size();
        }
        if (this.type.equals(TYPE_BINARY)) {
            if (this.getBinaryValue() != null) {
                return 1;
            }
            return 0;
        }
        throw new IllegalStateException("Type has not supported value. Name=" + this.name + "; type=" + this.type);
    }
}

