/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exception.control;

import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.exception.control.ExceptionHandlingFlow;
import org.apache.deltaspike.core.api.exception.control.event.ExceptionStackEvent;
import org.apache.deltaspike.core.spi.exception.control.event.IntrospectiveExceptionEvent;

@Typed
public class DefaultExceptionEvent<T extends Throwable>
implements IntrospectiveExceptionEvent<T> {
    private final T exception;
    private boolean unmute;
    private ExceptionHandlingFlow flow;
    private Throwable throwNewException;
    private final boolean beforeTraversal;
    private final boolean markedHandled;

    public DefaultExceptionEvent(ExceptionStackEvent stackEvent, boolean beforeTraversal, boolean handled) {
        if (stackEvent == null) {
            throw new IllegalArgumentException("null is not valid for stackEvent");
        }
        this.exception = stackEvent.getCurrent();
        this.beforeTraversal = beforeTraversal;
        this.markedHandled = handled;
        this.flow = ExceptionHandlingFlow.HANDLED_AND_CONTINUE;
    }

    @Override
    public T getException() {
        return this.exception;
    }

    @Override
    public void abort() {
        this.flow = ExceptionHandlingFlow.ABORT;
    }

    @Override
    public void throwOriginal() {
        this.flow = ExceptionHandlingFlow.THROW_ORIGINAL;
    }

    @Override
    public void handled() {
        this.flow = ExceptionHandlingFlow.HANDLED;
    }

    @Override
    public void handledAndContinue() {
        this.flow = ExceptionHandlingFlow.HANDLED_AND_CONTINUE;
    }

    @Override
    public void skipCause() {
        this.flow = ExceptionHandlingFlow.SKIP_CAUSE;
    }

    @Override
    public void unmute() {
        this.unmute = true;
    }

    @Override
    public boolean isUnmute() {
        return this.unmute;
    }

    @Override
    public ExceptionHandlingFlow getCurrentExceptionHandlingFlow() {
        return this.flow;
    }

    @Override
    public boolean isMarkedHandled() {
        return this.markedHandled;
    }

    @Override
    public boolean isBeforeTraversal() {
        return this.beforeTraversal;
    }

    @Override
    public void rethrow(Throwable t) {
        this.throwNewException = t;
        this.flow = ExceptionHandlingFlow.THROW;
    }

    @Override
    public Throwable getThrowNewException() {
        return this.throwNewException;
    }
}

