/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authorization;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.security.api.authorization.Secures;
import org.picketlink.Identity;
import org.picketlink.authorization.annotations.GroupsAllowed;
import org.picketlink.authorization.annotations.LoggedIn;
import org.picketlink.authorization.annotations.PartitionsAllowed;
import org.picketlink.authorization.annotations.RequiresPermission;
import org.picketlink.authorization.annotations.Restrict;
import org.picketlink.authorization.annotations.RolesAllowed;
import org.picketlink.authorization.util.AuthorizationUtil;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Partition;
import org.picketlink.internal.el.ELProcessor;

public class DefaultAuthorizationManager {
    @Inject
    private BeanManager beanManager;
    @Inject
    @Any
    private Identity identity;
    @Inject
    private ELProcessor elProcessor;
    @Inject
    private PartitionManager partitionManager;
    @Inject
    private IdentityManager identityManager;
    @Inject
    private RelationshipManager relationshipManager;

    @Secures
    @LoggedIn
    public boolean isLoggedIn(InvocationContext invocationContext) {
        Account account;
        LoggedIn loggedIn = this.getAnnotation(invocationContext, LoggedIn.class);
        Class<Account> accountType = Account.class;
        if (loggedIn != null) {
            accountType = loggedIn.requiresAccount();
        }
        return (account = this.getIdentity().getAccount()) != null && accountType.isInstance(account);
    }

    @Secures
    @Restrict
    public boolean checkExpression(InvocationContext invocationContext) {
        Restrict restrict;
        String expression;
        Object result;
        if (this.isLoggedIn(invocationContext) && Boolean.class.isInstance(result = this.elProcessor.eval(expression = (restrict = this.getAnnotation(invocationContext, Restrict.class)).value()))) {
            return Boolean.valueOf(result.toString());
        }
        return false;
    }

    @Secures
    @RequiresPermission
    public boolean hasPermission(InvocationContext invocationContext) {
        RequiresPermission requiresPermission = this.getAnnotation(invocationContext, RequiresPermission.class);
        String resource = requiresPermission.resource();
        String operation = requiresPermission.operation();
        return AuthorizationUtil.hasPermission(this.getIdentity(), resource, operation);
    }

    @Secures
    @RolesAllowed
    public boolean hasRole(InvocationContext invocationContext) {
        RolesAllowed rolesAllowed = this.getAnnotation(invocationContext, RolesAllowed.class);
        for (String roleName : rolesAllowed.value()) {
            if (!AuthorizationUtil.hasRole(this.getIdentity(), this.partitionManager, this.identityManager, this.relationshipManager, roleName)) continue;
            return true;
        }
        return false;
    }

    @Secures
    @GroupsAllowed
    public boolean isMember(InvocationContext invocationContext) {
        String[] groupNames;
        GroupsAllowed groupsAllowed = this.getAnnotation(invocationContext, GroupsAllowed.class);
        for (String groupName : groupNames = groupsAllowed.value()) {
            if (!AuthorizationUtil.isMember(this.getIdentity(), this.partitionManager, this.identityManager, this.relationshipManager, groupName)) continue;
            return true;
        }
        return false;
    }

    @Secures
    @PartitionsAllowed
    public boolean hasPartition(InvocationContext invocationContext) {
        PartitionsAllowed partitionsAllowed = this.getAnnotation(invocationContext, PartitionsAllowed.class);
        String[] partitionNames = partitionsAllowed.name();
        Class<? extends Partition> partitionType = partitionsAllowed.type();
        return AuthorizationUtil.hasPartition(this.getIdentity(), partitionType, partitionNames);
    }

    private <T extends Annotation> T getAnnotation(InvocationContext invocationContext, Class<T> annotationType) {
        Object targetBean = invocationContext.getTarget();
        T annotation = targetBean.getClass().getAnnotation(annotationType);
        if (annotation == null) {
            annotation = invocationContext.getMethod().getAnnotation(annotationType);
        }
        return annotation;
    }

    private Identity getIdentity() {
        return this.identity;
    }
}

