/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.config.AbstractIdentityConfigurationChildBuilder;
import org.picketlink.idm.config.Builder;
import org.picketlink.idm.config.LDAPMappingConfiguration;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.config.annotation.ParameterConfigID;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.AttributeProperty;

public class LDAPMappingConfigurationBuilder
extends AbstractIdentityConfigurationChildBuilder<LDAPMappingConfiguration> {
    private final LDAPStoreConfigurationBuilder ldapStoreBuilder;
    private Class<? extends AttributedType> mappedClass;
    private final Set<String> objectClasses = new HashSet<String>();
    private String baseDN;
    private String idPropertyName;
    private final Map<String, String> mappedProperties = new HashMap<String, String>();
    private final Set<String> readOnlyAttributes = new HashSet<String>();
    private final Map<String, String> parentMapping = new HashMap<String, String>();
    private Class<? extends AttributedType> relatedAttributedType;
    private String parentMembershipAttributeName;
    private int hierarchySearchDepth = 3;

    public LDAPMappingConfigurationBuilder(Class<? extends AttributedType> attributedType, LDAPStoreConfigurationBuilder builder) {
        super(builder);
        this.mappedClass = attributedType;
        this.ldapStoreBuilder = builder;
    }

    @Override
    protected LDAPMappingConfiguration create() {
        return new LDAPMappingConfiguration(this.mappedClass, this.objectClasses, this.baseDN, this.idPropertyName, this.mappedProperties, this.readOnlyAttributes, this.parentMapping, this.relatedAttributedType, this.parentMembershipAttributeName, this.hierarchySearchDepth);
    }

    @Override
    protected void validate() {
        if (this.mappedClass == null) {
            throw new SecurityConfigurationException("Mapped class not provided.");
        }
        if (this.hierarchySearchDepth < 0) {
            throw new SecurityConfigurationException("The hierarchy search depth can not be negative.");
        }
        if (!Relationship.class.isAssignableFrom(this.mappedClass) && StringUtil.isNullOrEmpty(this.idPropertyName)) {
            throw new SecurityConfigurationException("No attribute provided as the identifier for mapped class [" + this.mappedClass + "].");
        }
        for (String propertyName : this.mappedProperties.keySet()) {
            Property property = PropertyQueries.createQuery(this.mappedClass).addCriteria(new NamedPropertyCriteria(propertyName)).getFirstResult();
            if (property == null) {
                throw new SecurityConfigurationException("Could not resolve property [" + propertyName + "] from mapped class [" + this.mappedClass + "].");
            }
            if (property.isAnnotationPresent(AttributeProperty.class) || Relationship.class.isAssignableFrom(this.mappedClass)) continue;
            throw new SecurityConfigurationException("Mapped properties must be annotated with @AttributeProperty. Property [" + this.mappedClass + "." + propertyName + "].");
        }
    }

    @Override
    protected Builder<LDAPMappingConfiguration> readFrom(LDAPMappingConfiguration fromConfiguration) {
        this.mappedClass = fromConfiguration.getMappedClass();
        this.objectClasses.addAll(fromConfiguration.getObjectClasses());
        this.baseDN = fromConfiguration.getBaseDN();
        if (fromConfiguration.getIdProperty() != null) {
            this.idPropertyName = fromConfiguration.getIdProperty().getName();
        }
        this.mappedProperties.putAll(fromConfiguration.getMappedProperties());
        this.readOnlyAttributes.addAll(fromConfiguration.getReadOnlyAttributes());
        this.parentMapping.putAll(fromConfiguration.getParentMapping());
        this.relatedAttributedType = fromConfiguration.getRelatedAttributedType();
        this.parentMembershipAttributeName = fromConfiguration.getParentMembershipAttributeName();
        this.hierarchySearchDepth = fromConfiguration.getHierarchySearchDepth();
        return this;
    }

    public LDAPMappingConfigurationBuilder objectClasses(String ... objectClasses) {
        this.objectClasses.addAll(Arrays.asList(objectClasses));
        return this;
    }

    public LDAPMappingConfigurationBuilder attribute(@ParameterConfigID(name="propertyName") String propertyName, @ParameterConfigID(name="ldapAttributeName") String ldapAttributeName) {
        this.mappedProperties.put(propertyName, ldapAttributeName);
        return this;
    }

    public LDAPMappingConfigurationBuilder readOnlyAttribute(@ParameterConfigID(name="propertyName") String propertyName, @ParameterConfigID(name="ldapAttributeName") String ldapAttributeName) {
        this.mappedProperties.put(propertyName, ldapAttributeName);
        this.readOnlyAttributes.add(propertyName);
        return this;
    }

    public LDAPMappingConfigurationBuilder attribute(@ParameterConfigID(name="propertyName") String propertyName, @ParameterConfigID(name="ldapAttributeName") String ldapAttributeName, @ParameterConfigID(name="identifier") boolean identifier) {
        this.attribute(propertyName, ldapAttributeName);
        if (identifier) {
            this.idPropertyName = propertyName;
        }
        return this;
    }

    public LDAPMappingConfigurationBuilder hierarchySearchDepth(int hierarchySearchDepth) {
        this.hierarchySearchDepth = hierarchySearchDepth;
        return this;
    }

    public LDAPMappingConfigurationBuilder mapping(Class<? extends AttributedType> attributedType) {
        return this.ldapStoreBuilder.mapping(attributedType);
    }

    public LDAPMappingConfigurationBuilder baseDN(String baseDN) {
        this.baseDN = baseDN;
        return this;
    }

    public LDAPMappingConfigurationBuilder forMapping(Class<? extends AttributedType> attributedType) {
        this.relatedAttributedType = attributedType;
        return this;
    }

    public LDAPMappingConfigurationBuilder parentMembershipAttributeName(String parentMembershipAttributeName) {
        this.parentMembershipAttributeName = parentMembershipAttributeName;
        return this;
    }

    public LDAPMappingConfigurationBuilder parentMapping(String parentId, String baseDN) {
        this.parentMapping.put(parentId, baseDN);
        return this;
    }
}

